/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.inventory.UncraftingContainer;

public class UncraftingGuiPacket {
    private final int type;

    public UncraftingGuiPacket(int type) {
        this.type = type;
    }

    public UncraftingGuiPacket(FriendlyByteBuf buf) {
        this.type = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
    }

    public static class Handler {
        public static boolean onMessage(final UncraftingGuiPacket message, Supplier<NetworkEvent.Context> ctx) {
            final ServerPlayer player = ctx.get().getSender();
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    AbstractContainerMenu container = player.f_36096_;
                    if (container instanceof UncraftingContainer) {
                        UncraftingContainer uncrafting = (UncraftingContainer)container;
                        switch (message.type) {
                            case 0: {
                                ++uncrafting.unrecipeInCycle;
                                break;
                            }
                            case 1: {
                                --uncrafting.unrecipeInCycle;
                                break;
                            }
                            case 2: {
                                ++uncrafting.ingredientsInCycle;
                                break;
                            }
                            case 3: {
                                --uncrafting.ingredientsInCycle;
                                break;
                            }
                            case 4: {
                                ++uncrafting.recipeInCycle;
                                break;
                            }
                            case 5: {
                                --uncrafting.recipeInCycle;
                            }
                        }
                        if (message.type < 4) {
                            uncrafting.m_6199_(uncrafting.tinkerInput);
                        }
                        if (message.type >= 4) {
                            uncrafting.m_6199_((Container)uncrafting.assemblyMatrix);
                        }
                    }
                }
            });
            return true;
        }
    }
}

