/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.potions.TFMobEffects;
import twilightforest.util.PlayerHelper;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.start.LegacyStructureFeature;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.biomes.BiomeKeys;

public class TFGenerationSettings {
    private static final Map<ResourceLocation, ResourceLocation[]> BIOME_ADVANCEMENTS = new HashMap<ResourceLocation, ResourceLocation[]>();
    private static final Map<ResourceLocation, BiConsumer<Player, Level>> BIOME_PROGRESSION_ENFORCEMENT = new HashMap<ResourceLocation, BiConsumer<Player, Level>>();
    @Deprecated
    public static final int SEALEVEL = 0;
    public static final ResourceLocation DIMENSION;
    public static final ResourceKey<LevelStem> WORLDGEN_KEY;
    public static final ResourceKey<Level> DIMENSION_KEY;

    private static void registerBiomeAdvancementRestriction(ResourceKey<Biome> biome, ResourceLocation ... advancements) {
        BIOME_ADVANCEMENTS.put(biome.m_135782_(), advancements);
    }

    private static void registerBiomeProgressionEnforcement(ResourceKey<Biome> biome, BiConsumer<Player, Level> exec) {
        BIOME_PROGRESSION_ENFORCEMENT.put(biome.m_135782_(), exec);
    }

    public static void enforceBiomeProgression(Player player, Level world) {
        Biome currentBiome = (Biome)world.m_204166_(player.m_142538_()).m_203334_();
        if (TFGenerationSettings.isBiomeSafeFor(currentBiome, (Entity)player)) {
            return;
        }
        BiConsumer<Player, Level> exec = BIOME_PROGRESSION_ENFORCEMENT.get(currentBiome.getRegistryName());
        if (exec != null) {
            exec.accept(player, world);
        }
    }

    private static void trySpawnHintMonster(Player player, Level world, TFFeature feature) {
        if (world.f_46441_.nextInt(4) == 0) {
            feature.trySpawnHintMonster(world, player);
        }
    }

    public static boolean isTwilightPortalDestination(Level world) {
        return DIMENSION.equals((Object)world.m_46472_().m_135782_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isTwilightWorldOnClient(Level world) {
        return "twilightforest".equals(Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().m_135827_()) || TFGenerationSettings.isTwilightPortalDestination(world);
    }

    public static boolean usesTwilightChunkGenerator(ServerLevel world) {
        return world.m_7726_().m_8481_() instanceof ChunkGeneratorTwilight;
    }

    public static boolean isProgressionEnforced(Level world) {
        return world.m_46469_().m_46207_(TwilightForestMod.ENFORCED_PROGRESSION_RULE);
    }

    public static boolean isBiomeSafeFor(Biome biome, Entity entity) {
        ResourceLocation[] advancements = BIOME_ADVANCEMENTS.get(entity.f_19853_.m_5776_() ? entity.f_19853_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome) : biome.getRegistryName());
        if (advancements != null && entity instanceof Player) {
            return PlayerHelper.doesPlayerHaveRequiredAdvancements((Player)entity, advancements);
        }
        return true;
    }

    public static void markStructureConquered(Level world, BlockPos pos, TFFeature feature) {
        ChunkGeneratorTwilight generator = WorldUtil.getChunkGenerator((LevelAccessor)world);
        if (generator != null && TFFeature.getFeatureAt(pos.m_123341_(), pos.m_123343_(), (WorldGenLevel)((ServerLevel)world)) == feature) {
            TFGenerationSettings.locateTFStructureInRange((WorldGenLevel)((ServerLevel)world), feature, pos, 0).ifPresent(start -> {
                if (start instanceof TFStructureStart) {
                    TFStructureStart s = (TFStructureStart)((Object)start);
                    s.setConquered(true);
                }
            });
        }
    }

    public static Optional<StructureStart> locateTFStructureInRange(WorldGenLevel world, BlockPos pos, int range) {
        TFFeature featureCheck = TFFeature.getFeatureForRegionPos(pos.m_123341_(), pos.m_123343_(), world);
        return TFGenerationSettings.locateTFStructureInRange(world, featureCheck, pos, range);
    }

    public static Optional<StructureStart> locateTFStructureInRange(WorldGenLevel world, TFFeature featureCheck, BlockPos pos, int range) {
        int cx1 = Mth.m_14143_((float)(pos.m_123341_() - range >> 4));
        int cx2 = Mth.m_14167_((float)(pos.m_123341_() + range >> 4));
        int cz1 = Mth.m_14143_((float)(pos.m_123343_() - range >> 4));
        int cz2 = Mth.m_14167_((float)(pos.m_123343_() + range >> 4));
        for (ConfiguredStructureFeature structureFeature : world.m_5962_().m_206191_(Registry.f_122882_).m_123024_().toList()) {
            StructureFeature structureFeature2 = structureFeature.f_65403_;
            if (!(structureFeature2 instanceof LegacyStructureFeature)) continue;
            LegacyStructureFeature legacyData = (LegacyStructureFeature)structureFeature2;
            TFFeature feature = legacyData.feature;
            if (feature != featureCheck) continue;
            for (int x = cx1; x <= cx2; ++x) {
                for (int z = cz1; z <= cz2; ++z) {
                    Optional<StructureStart> structure = world.m_46819_(x, z, ChunkStatus.f_62315_).m_207420_(structureFeature).stream().map(longVal -> SectionPos.m_123196_((ChunkPos)new ChunkPos(longVal.longValue()), (int)0)).map(sectionPos -> world.m_7232_(sectionPos.m_123170_(), sectionPos.m_123222_()) ? world.m_46819_(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62315_).m_207072_(structureFeature) : null).filter(structureStart -> structureStart != null && structureStart.m_73603_()).findFirst();
                    if (!structure.isPresent()) continue;
                    return structure;
                }
            }
        }
        return Optional.empty();
    }

    static {
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.DARK_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.DARK_FOREST_CENTER, TwilightForestMod.prefix("progress_knights"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.FINAL_PLATEAU, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.FIRE_SWAMP, TwilightForestMod.prefix("progress_labyrinth"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.GLACIER, TwilightForestMod.prefix("progress_yeti"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.HIGHLANDS, TwilightForestMod.prefix("progress_merge"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.SNOWY_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.SWAMP, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.THORNLANDS, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.DARK_FOREST, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.KNIGHT_STRONGHOLD);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.DARK_FOREST_CENTER, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.DARK_TOWER);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.FINAL_PLATEAU, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 5 == 0) {
                player.m_6469_(DamageSource.f_19319_, 1.5f);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), TFSounds.ACID_RAIN_BURNS, SoundSource.PLAYERS, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.FIRE_SWAMP, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 60 == 0) {
                player.m_20254_(8);
            }
            TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.HYDRA_LAIR);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.GLACIER, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100, 3, false, true));
            }
            TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.ICE_TOWER);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.HIGHLANDS, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 5 == 0) {
                player.m_6469_(DamageSource.f_19319_, 0.5f);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), TFSounds.ACID_RAIN_BURNS, SoundSource.PLAYERS, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.SNOWY_FOREST, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100, 2, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.YETI_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.SWAMP, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 60 == 0) {
                MobEffectInstance currentHunger = player.m_21124_(MobEffects.f_19612_);
                int hungerLevel = currentHunger != null ? currentHunger.m_19564_() + 1 : 1;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, hungerLevel, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.LABYRINTH);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.THORNLANDS, (player, world) -> {
            if (!world.f_46443_ && player.f_19797_ % 5 == 0) {
                player.m_6469_(DamageSource.f_19319_, 1.0f);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), TFSounds.ACID_RAIN_BURNS, SoundSource.PLAYERS, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        DIMENSION = TwilightForestMod.prefix("twilight_forest");
        WORLDGEN_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)DIMENSION);
        DIMENSION_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)DIMENSION);
    }
}

