/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import journeymap.client.JourneymapClient;
import journeymap.client.api.model.WrappedEntity;
import journeymap.client.model.EntityHelper;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class EntityDTO
implements WrappedEntity,
Serializable {
    public final String entityId;
    public transient WeakReference<LivingEntity> entityLivingRef;
    public transient ResourceLocation entityIconLocation;
    public String iconLocation;
    public Boolean hostile;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    private BlockPos chunkPos;
    public double heading;
    private Component customName;
    public String serializedCustomName;
    public String owner;
    public String profession;
    public String username;
    public String biome;
    public ResourceKey<Level> dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;
    public boolean npc;
    public int color;
    private List<Component> entityToolTips;
    private List<String> serializedTooltips;
    public boolean disabled = false;

    private EntityDTO(LivingEntity entity) {
        this.entityLivingRef = new WeakReference<LivingEntity>(entity);
        this.entityId = entity.m_142081_().toString();
    }

    public void update(LivingEntity entity, boolean hostile) {
        LivingEntity attackTarget;
        Entity ownerEntity;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer currentPlayer = Minecraft.m_91087_().f_91074_;
        this.dimension = DimensionHelper.getDimension((Entity)entity);
        this.posX = entity.m_20182_().m_7096_();
        this.posY = entity.m_20182_().m_7098_();
        this.posZ = entity.m_20182_().m_7094_();
        this.chunkCoordX = entity.m_146902_().f_45578_;
        this.chunkCoordY = entity.m_146904_() >> 4;
        this.chunkCoordZ = entity.m_146902_().f_45579_;
        this.chunkPos = new BlockPos(this.chunkCoordX, this.chunkCoordY, this.chunkCoordZ);
        this.heading = Math.round(entity.m_146908_() % 360.0f);
        this.disabled = false;
        this.customName = null;
        this.serializedCustomName = null;
        this.entityToolTips = null;
        this.invisible = currentPlayer != null ? entity.m_20177_((Player)currentPlayer) : false;
        this.sneaking = entity.m_6144_();
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        ResourceLocation entityIcon = null;
        int playerColor = coreProperties.getColor(coreProperties.colorPlayer);
        PlayerTeam team = null;
        try {
            team = mc.f_91073_.m_6188_().m_83500_(entity.m_20149_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entity instanceof Player) {
            this.username = StringUtil.m_14406_((String)entity.m_7755_().getString());
            try {
                playerColor = team != null ? team.m_7414_().m_126656_() : (currentPlayer.equals((Object)entity) ? coreProperties.getColor(coreProperties.colorSelf) : coreProperties.getColor(coreProperties.colorPlayer));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            entityIcon = DefaultPlayerSkin.m_118626_();
            try {
                ClientPacketListener client = Minecraft.m_91087_().m_91403_();
                PlayerInfo info = client.m_104949_(entity.m_142081_());
                if (info != null) {
                    entityIcon = info.m_105337_();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error looking up player skin: " + LogFormatter.toPartialString(t));
            }
        } else {
            this.username = null;
            entityIcon = EntityHelper.getIconTextureLocation((Entity)entity);
        }
        if (entityIcon != null) {
            this.entityIconLocation = entityIcon;
            this.iconLocation = entityIcon.toString();
        }
        if ((ownerEntity = this.getTamedOwner(entity)) != null) {
            this.owner = ownerEntity.m_7755_().getString();
        }
        Component customName = null;
        boolean passive = false;
        LivingEntity entityLiving = entity;
        if (entity.m_8077_() && entityLiving.m_6052_()) {
            customName = entity.m_7770_();
        }
        if (!hostile && currentPlayer != null && (attackTarget = entity.m_21232_()) != null && attackTarget.m_142081_().equals(currentPlayer.m_142081_())) {
            hostile = true;
        }
        if (EntityHelper.isPassive(entity)) {
            passive = true;
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.profession = villager.m_7141_().m_35571_().m_35622_().m_148688_();
        } else if (entity instanceof Npc) {
            this.npc = true;
            this.profession = null;
            this.passiveAnimal = false;
        } else {
            this.profession = null;
            this.passiveAnimal = passive;
        }
        if (customName != null) {
            this.setCustomName(customName);
        }
        this.hostile = hostile;
        this.color = entity instanceof Player ? playerColor : (team != null ? team.m_7414_().m_126656_() : (this.owner != null ? coreProperties.getColor(coreProperties.colorPet) : (this.profession != null || this.npc ? coreProperties.getColor(coreProperties.colorVillager) : (hostile ? coreProperties.getColor(coreProperties.colorHostile) : coreProperties.getColor(coreProperties.colorPassive)))));
    }

    private Entity getTamedOwner(LivingEntity livingEntity) {
        LocalPlayer currentPlayer = Minecraft.m_91087_().f_91074_;
        if (livingEntity instanceof TamableAnimal) {
            LivingEntity ownerEntity = ((TamableAnimal)livingEntity).m_142480_();
            if (ownerEntity != null) {
                return ownerEntity;
            }
        } else if (livingEntity instanceof Horse) {
            UUID ownerUuid = ((Horse)livingEntity).m_30615_();
            if (currentPlayer != null && ownerUuid != null) {
                try {
                    String playerUuid = currentPlayer.m_142081_().toString();
                    if (playerUuid.equals(ownerUuid.toString())) {
                        return currentPlayer;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public WeakReference<LivingEntity> getEntityLivingRef() {
        return this.entityLivingRef;
    }

    @Override
    public ResourceLocation getEntityIconLocation() {
        return this.entityIconLocation;
    }

    @Override
    public Boolean getHostile() {
        return this.hostile;
    }

    @Override
    public Vec3 getPosition() {
        return ((LivingEntity)this.entityLivingRef.get()).m_20182_();
    }

    @Override
    public BlockPos getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public double getHeading() {
        return this.heading;
    }

    @Override
    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public Entity getOwner() {
        return this.getTamedOwner((LivingEntity)this.entityLivingRef.get());
    }

    @Override
    public String getProfession() {
        return this.profession;
    }

    @Override
    public String getPlayerName() {
        return this.username;
    }

    @Override
    public Biome getBiome() {
        return (Biome)Minecraft.m_91087_().f_91073_.m_204166_(((LivingEntity)this.entityLivingRef.get()).m_142538_()).m_203334_();
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public Boolean getUnderground() {
        return this.underground;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isPassiveAnimal() {
        return this.passiveAnimal;
    }

    @Override
    public boolean isNpc() {
        return this.npc;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setCustomName(String customName) {
        this.setCustomName((Component)new TextComponent(customName));
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.serializedCustomName = Component.Serializer.m_130703_((Component)customName);
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public void setDisable(boolean disable) {
        this.disabled = disable;
    }

    @Override
    public void setEntityIconLocation(ResourceLocation entityIconLocation) {
        this.entityIconLocation = entityIconLocation;
        this.iconLocation = entityIconLocation.toString();
    }

    @Override
    public List<Component> getEntityToolTips() {
        return this.entityToolTips;
    }

    @Override
    public void setEntityToolTips(List<Component> entityToolTips) {
        this.entityToolTips = entityToolTips;
        this.serializedTooltips = entityToolTips.stream().map(Component.Serializer::m_130703_).collect(Collectors.toList());
    }

    public static class EntityDTOExclusionStrategy
    implements ExclusionStrategy {
        List<String> excludedFields = Lists.newArrayList((Object[])new String[]{"customName", "chunkPos", "entityToolTips", "dimension"});

        public boolean shouldSkipField(FieldAttributes f) {
            if (f.getDeclaringClass().equals(EntityDTO.class)) {
                return this.excludedFields.contains(f.getName());
            }
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, EntityDTO> {
        public EntityDTO load(LivingEntity entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

