/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.main;

import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import org.apache.logging.log4j.Logger;

public class MappingMonitorTask
implements IMainThreadTask {
    private static String NAME = "Tick." + MappingMonitorTask.class.getSimpleName();
    Logger logger = Journeymap.getLogger();
    private Holder<DimensionType> lastDimension = null;

    @Override
    public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
        try {
            boolean isGamePaused;
            boolean isDead;
            if (!jm.isInitialized().booleanValue()) {
                return this;
            }
            boolean bl = isDead = mc.f_91080_ != null && mc.f_91080_ instanceof DeathScreen;
            if (mc.f_91073_ == null) {
                Screen guiScreen;
                if (jm.isMapping().booleanValue()) {
                    jm.stopMapping();
                }
                if (((guiScreen = mc.f_91080_) instanceof TitleScreen || guiScreen instanceof SelectWorldScreen || guiScreen instanceof JoinMultiplayerScreen) && jm.getCurrentWorldId() != null) {
                    this.logger.info("World ID has been reset.");
                    jm.setCurrentWorldId(null);
                }
                return this;
            }
            if (this.lastDimension == null || this.lastDimension.m_203543_().isPresent() && !mc.f_91074_.f_19853_.m_204156_().m_203565_((ResourceKey)this.lastDimension.m_203543_().get())) {
                this.lastDimension = mc.f_91074_.f_19853_.m_204156_();
                if (jm.isMapping().booleanValue()) {
                    jm.stopMapping();
                }
            } else if (!jm.isMapping().booleanValue() && !isDead && JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                jm.startMapping();
            }
            boolean bl2 = isGamePaused = mc.f_91080_ != null && !(mc.f_91080_ instanceof Fullscreen);
            if (isGamePaused && !jm.isMapping().booleanValue()) {
                return this;
            }
            if (!isGamePaused) {
                ChatLog.showChatAnnouncements(mc);
            }
            if (!jm.isMapping().booleanValue() && JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                jm.startMapping();
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in JourneyMap.performMainThreadTasks(): " + LogFormatter.toString(t));
        }
        return this;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

