/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.JSONHelper;
import net.darkhax.bookshelf.mixin.util.random.AccessorWeightedRandomList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public interface ISerializer<T> {
    public T fromJSON(JsonElement var1);

    default public T fromJSON(JsonObject json, String memberName) {
        return this.fromJSON(json.get(memberName));
    }

    default public T fromJSON(JsonObject json, String memberName, T fallback) {
        return json.has(memberName) ? this.fromJSON(json, memberName) : fallback;
    }

    default public T fromJSON(JsonObject json, String memberName, Supplier<T> fallback) {
        return json.has(memberName) ? this.fromJSON(json, memberName) : fallback.get();
    }

    default public void toJSON(JsonObject json, String name, T toWrite) {
        json.add(name, this.toJSON(toWrite));
    }

    public JsonElement toJSON(T var1);

    public T fromByteBuf(FriendlyByteBuf var1);

    public void toByteBuf(FriendlyByteBuf var1, T var2);

    public Tag toNBT(T var1);

    public T fromNBT(Tag var1);

    default public T fromNBT(CompoundTag tag, String name) {
        if (tag.m_128441_(name)) {
            return this.fromNBT(tag.m_128423_(name));
        }
        throw new NBTParseException("Required tag " + name + " was not present.");
    }

    default public T fromNBT(@Nullable CompoundTag tag, String name, T fallback) {
        return tag != null && tag.m_128441_(name) ? this.fromNBT(tag.m_128423_(name)) : fallback;
    }

    default public void toNBT(CompoundTag tag, String name, T toWrite) {
        tag.m_128365_(name, this.toNBT(toWrite));
    }

    default public List<T> fromJSONList(JsonElement json) {
        ArrayList<T> list = new ArrayList<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                list.add(this.fromJSON(element));
            }
        } else {
            list.add(this.fromJSON(json));
        }
        return list;
    }

    default public List<T> fromJSONList(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.fromJSONList(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public List<T> fromJSONList(JsonObject json, String memberName, List<T> fallback) {
        return json.has(memberName) ? this.fromJSONList(json, memberName) : fallback;
    }

    default public List<T> fromJSONList(JsonObject json, String memberName, Supplier<List<T>> fallback) {
        return json.has(memberName) ? this.fromJSONList(json, memberName) : fallback.get();
    }

    default public JsonElement toJSONList(List<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.toJSON(t)));
        return json;
    }

    default public List<T> fromByteBufList(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.fromByteBuf(buffer));
        }
        return list;
    }

    default public void toByteBufList(FriendlyByteBuf buffer, List<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.toByteBuf(buffer, t));
    }

    default public Set<T> fromJSONSet(JsonElement json) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                set.add(this.fromJSON(element));
            }
        } else {
            set.add(this.fromJSON(json));
        }
        return set;
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.fromJSONSet(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName, Set<T> fallback) {
        return json.has(memberName) ? this.fromJSONSet(json, memberName) : fallback;
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName, Supplier<Set<T>> fallback) {
        return json.has(memberName) ? this.fromJSONSet(json, memberName) : fallback.get();
    }

    default public JsonElement toJSONSet(Set<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.toJSON(t)));
        return json;
    }

    default public Set<T> readByteBufSet(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        LinkedHashSet<T> set = new LinkedHashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.fromByteBuf(buffer));
        }
        return set;
    }

    default public void writeByteBufSet(FriendlyByteBuf buffer, Set<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.toByteBuf(buffer, t));
    }

    default public Optional<T> fromJSONOptional(JsonObject json, String memberName) {
        return this.fromJSONOptional(json.get(memberName));
    }

    default public Optional<T> fromJSONOptional(@Nullable JsonElement json) {
        return json != null ? Optional.ofNullable(this.fromJSON(json)) : Optional.empty();
    }

    @Nullable
    default public JsonElement toJSONOptional(@Nullable T value) {
        return this.toJSONOptional(Optional.ofNullable(value));
    }

    @Nullable
    default public JsonElement toJSONOptional(Optional<T> value) {
        return value.map(this::toJSON).orElse(null);
    }

    default public void toJSONOptional(JsonObject json, String memberName, Optional<T> value) {
        value.ifPresent(v -> json.add(memberName, this.toJSON(v)));
    }

    default public Optional<T> fromByteBufOptional(FriendlyByteBuf buffer) {
        return buffer.readBoolean() ? Optional.of(this.fromByteBuf(buffer)) : Optional.empty();
    }

    default public void toByteBufOptional(FriendlyByteBuf buffer, Optional<T> optional) {
        boolean isPresent = optional.isPresent();
        buffer.writeBoolean(isPresent);
        if (isPresent) {
            this.toByteBuf(buffer, optional.get());
        }
    }

    default public String toJSONString(T toWrite) {
        return this.toJSON(toWrite).toString();
    }

    default public T fromJSONString(String jsonString) {
        return this.fromJSON(JSONHelper.getAsElement(jsonString));
    }

    default public WeightedEntry.Wrapper<T> fromJSONWeighted(JsonElement element) {
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            T value = this.fromJSON(obj, "value");
            int weight = Serializers.INT.fromJSON(obj, "weight", 0);
            return WeightedEntry.m_146290_(value, (int)weight);
        }
        return WeightedEntry.m_146290_(this.fromJSON(element), (int)0);
    }

    default public JsonElement toJSONWeighted(WeightedEntry.Wrapper<T> weightedEntry) {
        JsonObject obj = new JsonObject();
        obj.add("value", this.toJSON(weightedEntry.m_146310_()));
        obj.addProperty("weight", (Number)weightedEntry.m_142631_().m_146281_());
        return obj;
    }

    default public void toByteBufWeighted(FriendlyByteBuf buffer, WeightedEntry.Wrapper<T> toWrite) {
        this.toByteBuf(buffer, toWrite.m_146310_());
        Serializers.INT.toByteBuf(buffer, toWrite.m_142631_().m_146281_());
    }

    default public WeightedEntry.Wrapper<T> fromByteBufWeighted(FriendlyByteBuf buffer) {
        T value = this.fromByteBuf(buffer);
        int weight = Serializers.INT.fromByteBuf(buffer);
        return WeightedEntry.m_146290_(value, (int)weight);
    }

    default public SimpleWeightedRandomList<T> fromJSONWeightedList(JsonElement json) {
        SimpleWeightedRandomList.Builder list = SimpleWeightedRandomList.m_146263_();
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            for (JsonElement element : array) {
                WeightedEntry.Wrapper<T> wrapped = this.fromJSONWeighted(element);
                list.m_146271_(wrapped.m_146310_(), wrapped.m_142631_().m_146281_());
            }
        } else {
            WeightedEntry.Wrapper<T> wrapped = this.fromJSONWeighted(json);
            list.m_146271_(wrapped.m_146310_(), wrapped.m_142631_().m_146281_());
        }
        return list.m_146270_();
    }

    default public JsonElement toJSONWeightedList(SimpleWeightedRandomList<T> list) {
        JsonArray array = new JsonArray();
        AccessorWeightedRandomList accessor = (AccessorWeightedRandomList)list;
        for (WeightedEntry.Wrapper entry : accessor.bookshelf$getEntries()) {
            array.add(this.toJSONWeighted(entry));
        }
        return array;
    }

    default public SimpleWeightedRandomList<T> fromByteBufWeightedList(FriendlyByteBuf buffer) {
        SimpleWeightedRandomList.Builder list = SimpleWeightedRandomList.m_146263_();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            WeightedEntry.Wrapper<T> wrapped = this.fromByteBufWeighted(buffer);
            list.m_146271_(wrapped.m_146310_(), wrapped.m_142631_().m_146281_());
        }
        return list.m_146270_();
    }

    default public void toByteBufWeightedList(FriendlyByteBuf buffer, SimpleWeightedRandomList<T> list) {
        AccessorWeightedRandomList accessor = (AccessorWeightedRandomList)list;
        buffer.writeInt(accessor.bookshelf$getEntries().size());
        for (WeightedEntry.Wrapper entry : accessor.bookshelf$getEntries()) {
            this.toByteBufWeighted(buffer, entry);
        }
    }
}

