/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestSerialization;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class BookshelfGameTests {
    @GameTestGenerator
    public static Collection<TestFunction> generate() {
        ArrayList<TestFunction> testFunctions = new ArrayList<TestFunction>();
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Boolean>("boolean", Serializers.BOOLEAN, false, true, true, false));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Byte>("byte", Serializers.BYTE, (byte)1, (byte)32, (byte)44, (byte)0));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Short>("short", Serializers.SHORT, (short)800, (short)1337));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Integer>("int", Serializers.INT, 54, 23, Integer.MAX_VALUE, 234234, Integer.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Long>("long", Serializers.LONG, 99L, 23441322L, Long.MIN_VALUE, 93015L, Long.MAX_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Float>("float", Serializers.FLOAT, Float.valueOf(8.0f), Float.valueOf(-23.456f), Float.valueOf(789.01f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-11.0f), Float.valueOf(Float.MIN_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Double>("double", Serializers.DOUBLE, 24.92, Double.MAX_VALUE, -922321.12345, Double.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<String>("string", Serializers.STRING, "one", "two", "3", "IV", ".....", "/I", "!@#$%^&*()_-"));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<UUID>("uuid", Serializers.UUID, UUID.randomUUID(), UUID.fromString("da0317d2-e550-11ec-8fea-0242ac120002"), UUID.randomUUID()));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<ResourceLocation>("resource_location", Serializers.RESOURCE_LOCATION, new ResourceLocation("hello_world"), new ResourceLocation("test", "two"), new ResourceLocation("test_from", "stuff/things/okay_stuff")));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<ItemStack>("item_stack", Serializers.ITEM_STACK, ItemStackHelper::areStacksEquivalent, (T[])ItemStackHelper.getTabItems(CreativeModeTab.f_40757_)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<CompoundTag>("nbt_compound_tag", Serializers.COMPOUND_TAG, (CompoundTag[])Arrays.stream(ItemStackHelper.getTabItems(CreativeModeTab.f_40757_)).filter(ItemStack::m_41782_).map(ItemStack::m_41783_).toArray(CompoundTag[]::new)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Component>("text_component", Serializers.TEXT, new TranslatableComponent("moon.phase.full").m_130940_(ChatFormatting.DARK_AQUA), new TextComponent("Hello World"), new TextComponent("okay").m_130938_(s -> s.m_131150_(new ResourceLocation("minecraft:alt")))));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<BlockPos>("block_pos", Serializers.BLOCK_POS, new BlockPos(1, 2, 3), new BlockPos(0, 0, 0), BlockPos.m_122022_((long)123456L)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Ingredient>("ingredient", Serializers.INGREDIENT, BookshelfGameTests::assertEqual, (T[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42428_}), Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42745_)}), Ingredient.m_204132_((TagKey)ItemTags.f_13146_)}));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<BlockState>("block_state", Serializers.BLOCK_STATE, Blocks.f_50069_.m_49966_(), Blocks.f_50087_.m_49966_(), (BlockState)Blocks.f_50171_.m_49966_().m_61124_((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true))));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<AttributeModifier>("attribute_modifier", Serializers.ATTRIBUTE_MODIFIER, new AttributeModifier("test", 15.0, AttributeModifier.Operation.MULTIPLY_BASE), new AttributeModifier(UUID.randomUUID(), "test_2", 9.55, AttributeModifier.Operation.ADDITION), new AttributeModifier("test3", 35.0, AttributeModifier.Operation.MULTIPLY_TOTAL)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<MobEffectInstance>("effect_instance", Serializers.EFFECT_INSTANCE, new MobEffectInstance(MobEffects.f_19617_, 100, 10), new MobEffectInstance(MobEffects.f_19594_, 10)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<EnchantmentInstance>("enchantment_instance", Serializers.ENCHANTMENT_INSTANCE, BookshelfGameTests::assertEncantmentInstanceEqual, (T[])new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.f_44965_, 5), new EnchantmentInstance(Enchantments.f_44975_, 15), new EnchantmentInstance(Enchantments.f_44956_, 2)}));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Rarity>("item_rarity", Serializers.ITEM_RARITY, Rarity.COMMON, Rarity.EPIC, Rarity.RARE, Rarity.RARE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Enchantment.Rarity>("enchantment_rarity", Serializers.ENCHANTMENT_RARITY, Enchantment.Rarity.COMMON, Enchantment.Rarity.COMMON, Enchantment.Rarity.RARE, Enchantment.Rarity.UNCOMMON));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<AttributeModifier.Operation>("attribute_modifier", Serializers.ATTRIBUTE_OPERATION, AttributeModifier.Operation.ADDITION, AttributeModifier.Operation.ADDITION, AttributeModifier.Operation.MULTIPLY_BASE, AttributeModifier.Operation.MULTIPLY_TOTAL, AttributeModifier.Operation.MULTIPLY_TOTAL));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Block>("registry_block", Serializers.BLOCK, Blocks.f_49992_, Blocks.f_50069_, Blocks.f_50575_, Blocks.f_49992_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Item>("registry_item", Serializers.ITEM, Items.f_42410_, Items.f_42398_, Items.f_42398_, Items.f_42486_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Enchantment>("registry_enchantment", Serializers.ENCHANTMENT, Enchantments.f_44965_, Enchantments.f_44968_, Enchantments.f_44968_, Enchantments.f_44985_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Motive>("registry_motive", Serializers.MOTIVE, Motive.f_31875_, Motive.f_31875_, Motive.f_31869_, Motive.f_31891_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Potion>("registry_potion", Serializers.POTION, Potions.f_43598_, Potions.f_43602_, Potions.f_43602_, Potions.f_43610_, Potions.f_43623_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Attribute>("registry_attribute", Serializers.ATTRIBUTE, Attributes.f_22284_, Attributes.f_22283_, Attributes.f_22276_, Attributes.f_22287_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<VillagerProfession>("registry_villager_profession", Serializers.VILLAGER_PROFESSION, VillagerProfession.f_35586_, VillagerProfession.f_35586_, VillagerProfession.f_35587_, VillagerProfession.f_35593_, VillagerProfession.f_35599_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<VillagerType>("registry_villager_type", Serializers.VILLAGER_TYPE, VillagerType.f_35824_, VillagerType.f_35820_, VillagerType.f_35820_, VillagerType.f_35821_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<SoundEvent>("registry_sound_event", Serializers.SOUND_EVENT, SoundEvents.f_11670_, SoundEvents.f_11720_, SoundEvents.f_11688_, SoundEvents.f_11805_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<MenuType>("registry_menu", Serializers.MENU, MenuType.f_39964_, MenuType.f_39958_, MenuType.f_39969_, MenuType.f_39979_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<ParticleType>("registry_particle_type", Serializers.PARTICLE, ParticleTypes.f_123772_, ParticleTypes.f_123774_, ParticleTypes.f_123796_, ParticleTypes.f_123778_, ParticleTypes.f_123786_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<EntityType>("registry_entity_type", Serializers.ENTITY, EntityType.f_20549_, EntityType.f_20548_, EntityType.f_147039_, EntityType.f_20561_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<BlockEntityType>("registry_block_entity_type", Serializers.BLOCK_ENTITY, BlockEntityType.f_58942_, BlockEntityType.f_58930_, BlockEntityType.f_58912_, BlockEntityType.f_58921_));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<GameEvent>("registry_game_event", Serializers.GAME_EVENT, GameEvent.f_157815_, GameEvent.f_157816_, GameEvent.f_157776_, GameEvent.f_157772_));
        BookshelfGameTests.testFromTags(testFunctions, "block_tag", Serializers.BLOCK_TAG, BlockTags.f_13033_, BlockTags.f_13038_, BlockTags.f_13062_);
        BookshelfGameTests.testFromTags(testFunctions, "item_tag", Serializers.ITEM_TAG, ItemTags.f_13141_, ItemTags.f_144321_, ItemTags.f_13185_);
        BookshelfGameTests.testFromTags(testFunctions, "enchantment_tag", Serializers.ENCHANTMENT_TAG, Services.TAGS.enchantmentTag(new ResourceLocation("test", "one")), Services.TAGS.enchantmentTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "motive_tag", Serializers.MOTIVE_TAG, Services.TAGS.paintingTag(new ResourceLocation("test", "one")), Services.TAGS.paintingTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "potion_tag", Serializers.POTION_TAG, Services.TAGS.potionTag(new ResourceLocation("test", "one")), Services.TAGS.potionTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "attribute_tag", Serializers.ATTRIBUTE_TAG, Services.TAGS.attributeTag(new ResourceLocation("test", "one")), Services.TAGS.attributeTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "villager_profession_tag", Serializers.VILLAGER_PROFESSION_TAG, Services.TAGS.villagerProfessionTag(new ResourceLocation("test", "one")), Services.TAGS.villagerProfessionTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "villager_type_tag", Serializers.VILLAGER_TYPE_TAG, Services.TAGS.villagerTypeTag(new ResourceLocation("test", "one")), Services.TAGS.villagerTypeTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "sound_event_tag", Serializers.SOUND_EVENT_TAG, Services.TAGS.soundTag(new ResourceLocation("test", "one")), Services.TAGS.soundTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "menu_tag", Serializers.MENU_TAG, Services.TAGS.menuTag(new ResourceLocation("test", "one")), Services.TAGS.menuTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "particle_type_tag", Serializers.PARTICLE_TAG, Services.TAGS.particleTag(new ResourceLocation("test", "one")), Services.TAGS.particleTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "entity_type_tag", Serializers.ENTITY_TAG, EntityTypeTags.f_13123_, EntityTypeTags.f_144292_, EntityTypeTags.f_144291_);
        BookshelfGameTests.testFromTags(testFunctions, "block_entity_type_tag", Serializers.BLOCK_ENTITY_TAG, Services.TAGS.blockEntityTag(new ResourceLocation("test", "one")), Services.TAGS.blockEntityTag(new ResourceLocation("test", "two")));
        BookshelfGameTests.testFromTags(testFunctions, "game_event_tag", Serializers.GAME_EVENT_TAG, GameEventTags.f_144303_, GameEventTags.f_144302_, GameEventTags.f_144302_);
        return testFunctions;
    }

    public static <T> void testFrom(Collection<TestFunction> functions, T testImpl) {
        String string;
        if (testImpl instanceof ITestable) {
            ITestable testObj = (ITestable)testImpl;
            string = testObj.getDefaultBatch();
        } else {
            string = null;
        }
        String parentBatch = string;
        for (Method method : testImpl.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(GameTest.class)) continue;
            GameTest annotation = method.getAnnotation(GameTest.class);
            String template = annotation.m_177046_().isEmpty() ? "bookshelf:empty" : annotation.m_177046_();
            String batch = parentBatch != null && annotation.m_177043_().equalsIgnoreCase("defaultBatch") ? parentBatch : annotation.m_177043_();
            String testName = batch + "." + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
            Rotation rotation = StructureUtils.m_127835_((int)annotation.m_177044_());
            functions.add(new TestFunction(batch, testName, template, rotation, annotation.m_177042_(), annotation.m_177047_(), annotation.m_177045_(), annotation.m_177049_(), annotation.m_177048_(), gameTestHelper -> {
                try {
                    method.invoke(testImpl, gameTestHelper);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
                }
                catch (InvocationTargetException e) {
                    RuntimeException runtimeException;
                    Throwable throwable = e.getCause();
                    RuntimeException rte = throwable instanceof RuntimeException ? (runtimeException = (RuntimeException)throwable) : new RuntimeException(e.getCause());
                    Constants.LOG.error("The test {} failed to run!", (Object)testName, (Object)e);
                    throw rte;
                }
            }));
        }
    }

    private static <T> void testFromTags(Collection<TestFunction> functions, String name, ISerializer<TagKey<T>> serializer, TagKey<T> ... tags) {
        BookshelfGameTests.testFrom(functions, new TestSerialization<TagKey<T>>(name, serializer, BookshelfGameTests::assertTagEqual, (T[])tags));
    }

    private static boolean assertEncantmentInstanceEqual(EnchantmentInstance a, EnchantmentInstance b) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a.f_44947_ != b.f_44947_) {
            Constants.LOG.error("Enchantment {} != {}", (Object)a.f_44947_, (Object)b.f_44947_);
            return false;
        }
        if (a.f_44948_ != b.f_44948_) {
            Constants.LOG.error("Level {} != {}", (Object)a.f_44948_, (Object)b.f_44948_);
            return false;
        }
        return true;
    }

    private static <T> boolean assertTagEqual(TagKey<T> a, TagKey<T> b) {
        return Objects.equals(a, b) || Objects.equals(a.f_203868_(), b.f_203868_());
    }

    private static boolean assertEqual(Ingredient original, Ingredient result) {
        ItemStack[] resultStacks;
        if (Objects.equals(original, result)) {
            return true;
        }
        ItemStack[] originalStacks = original.m_43908_();
        if (originalStacks.length != (resultStacks = result.m_43908_()).length) {
            Constants.LOG.error("Size mismatch. original={} result={}", (Object)originalStacks.length, (Object)resultStacks.length);
            return false;
        }
        for (int index = 0; index < originalStacks.length; ++index) {
            if (ItemStackHelper.areStacksEquivalent(originalStacks[index], resultStacks[index])) continue;
            Constants.LOG.error("Mismatch at index {}. original={} result={}", new Object[]{index, originalStacks[index], resultStacks[index]});
            return false;
        }
        return true;
    }
}

