/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.mixin.util.random.AccessorWeightedRandomList;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class TestSerialization<T>
implements ITestable {
    private final String type;
    private final ISerializer<T> serializer;
    private final T singleton;
    private final T[] collection;
    private final BiPredicate<T, T> equality;

    public TestSerialization(String type, ISerializer<T> serializer, T ... collection) {
        this(type, (ISerializer<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public TestSerialization(String type, ISerializer<T> serializer, BiPredicate<T, T> equality, T ... collection) {
        this(type, serializer, equality, collection[0], collection);
    }

    public TestSerialization(String type, ISerializer<T> serializer, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.serializer = serializer;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @GameTest
    public void testJsonSingleton(GameTestHelper helper) {
        JsonElement toJson = this.serializer.toJSON(this.singleton);
        T fromJson = this.serializer.fromJSON(toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.m_177284_("Singleton from" + this.type + " JSON does not match! a= " + this.singleton + " b= " + fromJson);
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testBytebufSingleton(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBuf(buffer, this.singleton);
        T fromBuffer = this.serializer.fromByteBuf(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.m_177284_("Singleton from" + this.type + " ByteBuf does not match! a= " + this.singleton + " b= " + fromBuffer);
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testNbtSingleton(GameTestHelper helper) {
        Tag toNBT = this.serializer.toNBT(this.singleton);
        T fromNBT = this.serializer.fromNBT(toNBT);
        if (!this.equality.test(this.singleton, fromNBT)) {
            helper.m_177284_("Singleton from" + this.type + " NBT does not match! a= " + this.singleton + " b= " + fromNBT);
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testJsonWeightedSingleton(GameTestHelper helper) {
        WeightedEntry.Wrapper weightedSingleton = WeightedEntry.m_146290_(this.singleton, (int)14);
        JsonElement toJson = this.serializer.toJSONWeighted(weightedSingleton);
        WeightedEntry.Wrapper<T> fromJson = this.serializer.fromJSONWeighted(toJson);
        if (!weightedSingleton.m_142631_().equals((Object)fromJson.m_142631_())) {
            helper.m_177284_("Weight for JSON does not match! a= " + weightedSingleton.m_142631_() + " b= " + fromJson.m_142631_());
        }
        if (!this.equality.test(this.singleton, fromJson.m_146310_())) {
            helper.m_177284_("Weighted Singleton from" + this.type + " JSON does not match! a= " + this.singleton + " b= " + fromJson.m_146310_());
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testBytebufWeightedSingleton(GameTestHelper helper) {
        WeightedEntry.Wrapper weightedSingleton = WeightedEntry.m_146290_(this.singleton, (int)14);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufWeighted(buffer, weightedSingleton);
        WeightedEntry.Wrapper<T> fromBuffer = this.serializer.fromByteBufWeighted(buffer);
        if (!weightedSingleton.m_142631_().equals((Object)fromBuffer.m_142631_())) {
            helper.m_177284_("Weight for ByteBuf does not match! a= " + weightedSingleton.m_142631_() + " b= " + fromBuffer.m_142631_());
        }
        if (!this.equality.test(this.singleton, fromBuffer.m_146310_())) {
            helper.m_177284_("Weighted Singleton from" + this.type + " ByteBuf does not match! a= " + this.singleton + " b= " + fromBuffer.m_146310_());
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testJsonOptionalSingleton(GameTestHelper helper) {
        Optional<T> original = Optional.ofNullable(this.singleton);
        JsonElement toJson = this.serializer.toJSONOptional(original);
        Optional<T> fromJson = this.serializer.fromJSONOptional(toJson);
        if (original.isPresent() && fromJson.isPresent() && !this.equality.test(original.get(), fromJson.get())) {
            helper.m_177284_("Optional Singleton from" + this.type + " JSON does not match! a= " + original.get() + " b= " + fromJson.get());
        }
        if (original.isPresent() != fromJson.isPresent()) {
            helper.m_177284_("Optional Singleton from " + this.type + " JSON availability mismatch. a= " + original.isPresent() + " b= " + fromJson.isPresent());
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testBytebufOptionalSingleton(GameTestHelper helper) {
        Optional<T> original = Optional.ofNullable(this.singleton);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufOptional(buffer, original);
        Optional<T> fromByteBuf = this.serializer.fromByteBufOptional(buffer);
        if (original.isPresent() && fromByteBuf.isPresent() && !this.equality.test(original.get(), fromByteBuf.get())) {
            helper.m_177284_("Optional Singleton from" + this.type + " ByteBuf does not match! a= " + original.get() + " b= " + fromByteBuf.get());
        }
        if (original.isPresent() != fromByteBuf.isPresent()) {
            helper.m_177284_("Optional Singleton from " + this.type + " ByteBuf availability mismatch. a= " + original.isPresent() + " b= " + fromByteBuf.isPresent());
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testJsonEmptyOptionalSingleton(GameTestHelper helper) {
        Optional original = Optional.empty();
        JsonElement toJson = this.serializer.toJSONOptional(original);
        Optional<T> fromJson = this.serializer.fromJSONOptional(toJson);
        if (original.isPresent() || fromJson.isPresent()) {
            helper.m_177284_("Empty Optional Singleton from" + this.type + " JSON was not empty! a= " + original.isPresent() + " b= " + fromJson.isPresent());
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testBytebufEmptyOptionalSingleton(GameTestHelper helper) {
        Optional original = Optional.empty();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufOptional(buffer, original);
        Optional<T> fromByteBuf = this.serializer.fromByteBufOptional(buffer);
        if (original.isPresent() || fromByteBuf.isPresent()) {
            helper.m_177284_("Empty Optional Singleton from" + this.type + " JSON was not empty! a= " + original.isPresent() + " b= " + fromByteBuf.isPresent());
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testJsonList(GameTestHelper helper) {
        List<T> list = List.of(this.collection);
        JsonElement written = this.serializer.toJSONList(list);
        List<T> read = this.serializer.fromJSONList(written);
        this.assertIterableEqual(helper, list, read);
    }

    @GameTest
    public void testBytebufList(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        List<T> list = List.of(this.collection);
        this.serializer.toByteBufList(buffer, list);
        List<T> read = this.serializer.fromByteBufList(buffer);
        this.assertIterableEqual(helper, list, read);
    }

    @GameTest
    public void testJsonSet(GameTestHelper helper) {
        Set<T> set = this.createSet();
        JsonElement written = this.serializer.toJSONSet(set);
        Set<T> read = this.serializer.fromJSONSet(written);
        this.assertIterableEqual(helper, set, read);
    }

    @GameTest
    public void testBytebufSet(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        Set<T> set = this.createSet();
        this.serializer.writeByteBufSet(buffer, set);
        Set<T> read = this.serializer.readByteBufSet(buffer);
        this.assertIterableEqual(helper, set, read);
    }

    @GameTest
    public void testJsonWeightedList(GameTestHelper helper) {
        SimpleWeightedRandomList<T> original = this.createWeightedList();
        JsonElement written = this.serializer.toJSONWeightedList(original);
        SimpleWeightedRandomList<T> read = this.serializer.fromJSONWeightedList(written);
        this.assertWeightedListEqual(helper, original, read);
    }

    @GameTest
    public void testBytebufWeightedList(GameTestHelper helper) {
        SimpleWeightedRandomList<T> original = this.createWeightedList();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufWeightedList(buffer, original);
        SimpleWeightedRandomList<T> read = this.serializer.fromByteBufWeightedList(buffer);
        this.assertWeightedListEqual(helper, original, read);
    }

    private Set<T> createSet() {
        LinkedHashSet values = new LinkedHashSet();
        Collections.addAll(values, this.collection);
        return values;
    }

    private SimpleWeightedRandomList<T> createWeightedList() {
        SimpleWeightedRandomList.Builder weightedList = SimpleWeightedRandomList.m_146263_();
        for (T value : this.collection) {
            weightedList.m_146271_(value, 25);
        }
        return weightedList.m_146270_();
    }

    private void assertWeightedListEqual(GameTestHelper helper, SimpleWeightedRandomList<T> original, SimpleWeightedRandomList<T> result) {
        AccessorWeightedRandomList accessOriginal = (AccessorWeightedRandomList)original;
        AccessorWeightedRandomList accessResult = (AccessorWeightedRandomList)result;
        if (accessOriginal.bookshelf$getEntries().size() != accessResult.bookshelf$getEntries().size()) {
            helper.m_177284_("List of type " + this.type + " has incorrect size. Original=" + accessOriginal.bookshelf$getEntries().size() + " Result=" + accessResult.bookshelf$getEntries().size());
        } else {
            for (int index = 0; index < accessOriginal.bookshelf$getEntries().size(); ++index) {
                WeightedEntry.Wrapper a = (WeightedEntry.Wrapper)accessOriginal.bookshelf$getEntries().get(index);
                WeightedEntry.Wrapper b = (WeightedEntry.Wrapper)accessResult.bookshelf$getEntries().get(index);
                if (a.m_142631_().m_146281_() != b.m_142631_().m_146281_()) {
                    helper.m_177284_("Weighted list of " + this.type + " do not match! index=" + index + " a=" + a.m_142631_().m_146281_() + " b=" + b.m_142631_().m_146281_());
                    return;
                }
                if (this.equality.test(a.m_146310_(), b.m_146310_())) continue;
                helper.m_177284_("Weighted list of " + this.type + " do not match! index=" + index + " a=" + a.m_146310_() + " b=" + b.m_146310_());
                return;
            }
            helper.m_177412_();
        }
    }

    private void assertIterableEqual(GameTestHelper helper, Iterable<T> original, Iterable<T> result) {
        int resultSize;
        int originalSize = Iterables.size(original);
        if (originalSize != (resultSize = Iterables.size(result))) {
            helper.m_177284_("List of type " + this.type + " has incorrect size. Original=" + originalSize + " Result=" + resultSize);
        } else {
            for (int index = 0; index < originalSize; ++index) {
                Object b;
                Object a = Iterables.get(original, (int)index);
                if (this.equality.test(a, b = Iterables.get(result, (int)index))) continue;
                helper.m_177284_("List of " + this.type + " do not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.m_177412_();
        }
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf_serialization_" + this.type;
    }
}

