/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.init;

import codechicken.chunkloader.client.ChunkLoaderItemModel;
import codechicken.chunkloader.client.TileChunkLoaderRenderer;
import codechicken.chunkloader.init.ChickenChunksModContent;
import codechicken.lib.model.ModelRegistryHelper;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static final ModelRegistryHelper modelHelper = new ModelRegistryHelper();

    public static void init() {
        LOCK.lock();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientInit::onRegisterRenderers);
        modelHelper.registerCallback(e -> {
            BakedModel loaderModel = (BakedModel)e.getModelRegistry().get(new ModelResourceLocation(ChickenChunksModContent.CHUNK_LOADER_BLOCK.getId(), ""));
            BakedModel spotModel = (BakedModel)e.getModelRegistry().get(new ModelResourceLocation(ChickenChunksModContent.SPOT_LOADER_BLOCK.getId(), ""));
            e.getModelRegistry().put(new ModelResourceLocation(ChickenChunksModContent.CHUNK_LOADER_ITEM.getId(), "inventory"), new ChunkLoaderItemModel(loaderModel, false));
            e.getModelRegistry().put(new ModelResourceLocation(ChickenChunksModContent.SPOT_LOADER_TILE.getId(), "inventory"), new ChunkLoaderItemModel(spotModel, true));
        });
    }

    private static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ChickenChunksModContent.CHUNK_LOADER_TILE.get()), TileChunkLoaderRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ChickenChunksModContent.SPOT_LOADER_TILE.get()), TileChunkLoaderRenderer::new);
    }
}

