/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class TileChunkLoaderBase
extends BlockEntity
implements IChunkLoader {
    @Nullable
    public UUID owner;
    @Nullable
    public Component ownerName;
    protected boolean loaded = false;
    protected boolean unloaded = false;
    protected boolean powered = false;
    public boolean active = false;
    @Nullable
    public RenderInfo renderInfo;

    public TileChunkLoaderBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("powered", this.powered);
        if (this.owner != null) {
            assert (this.ownerName != null);
            tag.m_128362_("owner", this.owner);
            tag.m_128359_("owner_name", Component.Serializer.m_130703_((Component)this.ownerName));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
            this.ownerName = Component.Serializer.m_130701_((String)tag.m_128461_("owner_name"));
        }
        if (tag.m_128441_("powered")) {
            this.powered = tag.m_128471_("powered");
        }
        this.loaded = true;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_ && this.loaded && !this.powered) {
            this.activate();
        }
        this.unloaded = false;
    }

    public void m_6339_() {
        super.m_6339_();
        if (this.f_58857_.f_46443_) {
            this.renderInfo = new RenderInfo();
        }
        this.unloaded = false;
    }

    public boolean isPowered() {
        for (Direction face : Direction.f_122348_) {
            boolean isPowered = TileChunkLoaderBase.isPoweringTo(this.f_58857_, this.m_58899_().m_142300_(face), face);
            if (!isPowered) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoweringTo(Level world, BlockPos pos, Direction side) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_().m_6378_(state, (BlockGetter)world, pos, side) > 0;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_ && !this.unloaded) {
            this.deactivate();
        }
    }

    public ChunkPos getChunkPosition() {
        return new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
    }

    public void onBlockPlacedBy(LivingEntity entityliving) {
        if (entityliving instanceof Player) {
            this.owner = entityliving.m_142081_();
            this.ownerName = entityliving.m_7755_();
        }
        this.activate();
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public Level world() {
        return this.f_58857_;
    }

    @Override
    public BlockPos pos() {
        return this.m_58899_();
    }

    @Override
    public void deactivate() {
        if (this.owner == null) {
            return;
        }
        this.loaded = true;
        this.active = false;
        IChunkLoaderHandler.getCapability((LevelAccessor)this.f_58857_).removeChunkLoader(this);
        ChunkLoaderSPH.sendStateUpdate(this);
    }

    @Override
    public void activate() {
        if (this.owner == null) {
            return;
        }
        this.loaded = true;
        this.active = true;
        IChunkLoaderHandler.getCapability((LevelAccessor)this.f_58857_).addChunkLoader(this);
        ChunkLoaderSPH.sendStateUpdate(this);
    }

    @Override
    public boolean isValid() {
        return !this.f_58859_;
    }

    public void tickServer() {
        boolean nowPowered = this.isPowered();
        if (this.powered != nowPowered) {
            this.powered = nowPowered;
            if (this.powered) {
                this.deactivate();
            } else {
                this.activate();
            }
        }
    }

    public void tickClient() {
        assert (this.renderInfo != null);
        this.renderInfo.update(this);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128379_("active", this.active);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.active = tag.m_128471_("active");
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeUUID(this.owner);
            packet.writeTextComponent(this.ownerName);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.active = packet.readBoolean();
        if (packet.readBoolean()) {
            this.owner = packet.readUUID();
            this.ownerName = packet.readTextComponent();
        }
    }

    public static class RenderInfo {
        public int activationCounter;
        public boolean showLasers;

        public void update(TileChunkLoaderBase chunkLoader) {
            if (this.activationCounter < 20 && chunkLoader.active) {
                ++this.activationCounter;
            } else if (this.activationCounter > 0 && !chunkLoader.active) {
                --this.activationCounter;
            }
        }
    }
}

