/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import de.maxhenkel.pipez.corelib.CachedValue;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;

public class ModelRegistry {
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Model model : Model.values()) {
            ForgeModelBakery.instance();
            ForgeModelBakery.addSpecialModel((ResourceLocation)model.getResourceLocation());
        }
    }

    public static void onModelBake(ModelBakeEvent event) {
        for (Model model : Model.values()) {
            model.getCachedModel().invalidate();
        }
    }

    public static enum Model {
        ENERGY_PIPE_EXTRACT("block/energy_pipe_extract"),
        FLUID_PIPE_EXTRACT("block/fluid_pipe_extract"),
        GAS_PIPE_EXTRACT("block/gas_pipe_extract"),
        ITEM_PIPE_EXTRACT("block/item_pipe_extract"),
        UNIVERSAL_PIPE_EXTRACT("block/universal_pipe_extract");

        private final ResourceLocation resource;
        private final CachedValue<BakedModel> cachedModel;

        private Model(String name) {
            this.resource = new ResourceLocation("pipez", name);
            this.cachedModel = new CachedValue<BakedModel>(() -> {
                UnbakedModel modelOrMissing = ForgeModelBakery.instance().getModelOrMissing(this.resource);
                return modelOrMissing.m_7611_((ModelBakery)ForgeModelBakery.instance(), arg_0 -> ((AtlasSet)ForgeModelBakery.instance().getSpriteMap()).m_117971_(arg_0), (ModelState)BlockModelRotation.X0_Y0, this.resource);
            });
        }

        public ResourceLocation getResourceLocation() {
            return this.resource;
        }

        public CachedValue<BakedModel> getCachedModel() {
            return this.cachedModel;
        }
    }
}

