/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.machine.CrucibleRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineCrucibleScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleRecipeCategory
extends ThermalRecipeCategory<CrucibleRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public CrucibleRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineCrucibleScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_crucible")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends CrucibleRecipe> getRecipeClass() {
        return CrucibleRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrucibleRecipe recipe, IFocusGroup focuses) {
        List inputs = recipe.getInputItems();
        List outputFluids = recipe.getOutputFluids();
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 15).addIngredients((Ingredient)inputs.get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of((FluidStack)outputFluids.get(0)))).setFluidRenderer(TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(CrucibleRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 74, 24);
        this.tankBackground.draw(matrixStack, 115, 10);
        this.speedBackground.draw(matrixStack, 43, 33);
        if (!recipe.getOutputFluids().isEmpty()) {
            RenderHelper.drawFluid((PoseStack)matrixStack, (int)74, (int)24, (FluidStack)((FluidStack)recipe.getOutputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 74, 24);
            this.progressFluid.draw(matrixStack, 74, 24);
        } else {
            this.progress.draw(matrixStack, 74, 24);
        }
        this.speed.draw(matrixStack, 43, 33);
    }
}

