/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ElvenTradeRecipeCategory
implements IRecipeCategory<IElvenTradeRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("elven_trade");
    private final Component localizedName = new TranslatableComponent("botania.nei.elvenTrade");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public ElvenTradeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/elven_trade_overlay.png"), 0, 15, 140, 90);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModBlocks.alfPortal));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IElvenTradeRecipe> getRecipeClass() {
        return IElvenTradeRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@Nonnull IElvenTradeRecipe recipe, @Nonnull IRecipeSlotsView slotsView, @Nonnull PoseStack matrices, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(matrices, 0, 4);
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl"));
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer v = immediate.m_6299_(RenderType.m_110451_());
        int startX = 22;
        int startY = 25;
        int stopX = 70;
        int stopY = 73;
        Matrix4f mat = matrices.m_85850_().m_85861_();
        Matrix3f n = matrices.m_85850_().m_85864_();
        v.m_85982_(mat, (float)startX, (float)startY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(0xF000F0).m_85977_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        v.m_85982_(mat, (float)startX, (float)stopY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(0xF000F0).m_85977_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        v.m_85982_(mat, (float)stopX, (float)stopY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(0xF000F0).m_85977_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        v.m_85982_(mat, (float)stopX, (float)startY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(0xF000F0).m_85977_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        immediate.m_109911_();
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull IElvenTradeRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        int posX = 42;
        for (Ingredient ingr : recipe.m_7527_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, posX, 0).addIngredients(ingr);
            posX += 18;
        }
        int outIdx = 0;
        for (ItemStack stack : recipe.getOutputs()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + outIdx % 2 * 20, 41 + outIdx / 2 * 20).addItemStack(stack);
            ++outIdx;
        }
    }
}

