/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.gui.crafting.ContainerCraftingHalo;
import vazkii.botania.client.integration.jei.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.ElvenTradeRecipeCategory;
import vazkii.botania.client.integration.jei.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.PureDaisyRecipeCategory;
import vazkii.botania.client.integration.jei.RunicAltarRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateRecipeCategory;
import vazkii.botania.client.integration.jei.crafting.AncientWillRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.CompositeLensRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.TerraPickTippingRecipeWrapper;
import vazkii.botania.client.integration.jei.orechid.MarimorphosisRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidIgnemRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeCategory;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraPickTippingRecipe;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemLaputaShard;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.IXplatAbstractions;

@JeiPlugin
public class JEIBotaniaPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("main");
    private static final Comparator<Recipe<?>> BY_ID = Comparator.comparing(Recipe::m_6423_);
    private static final Comparator<Recipe<?>> BY_GROUP = Comparator.comparing(Recipe::m_6076_);
    private static final Comparator<IOrechidRecipe> BY_INPUT = Comparator.comparing(r -> Registry.f_122824_.m_7447_((Object)r.getInput()));
    private static final Comparator<IOrechidRecipe> BY_WEIGHT = Comparator.comparing(IOrechidRecipe::getWeight).reversed();
    private static final Comparator<IManaInfusionRecipe> BY_CATALYST = (l, r) -> {
        StateIngredient left = l.getRecipeCatalyst();
        StateIngredient right = r.getRecipeCatalyst();
        if (left == null) {
            return right == null ? 0 : -1;
        }
        if (right == null) {
            return 1;
        }
        return left.toString().compareTo(right.toString());
    };

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter interpreter = (stack, ctx) -> ItemBrewBase.getSubtype(stack);
        registry.registerSubtypeInterpreter(ModItems.brewVial, interpreter);
        registry.registerSubtypeInterpreter(ModItems.brewFlask, interpreter);
        registry.registerSubtypeInterpreter(ModItems.incenseStick, interpreter);
        registry.registerSubtypeInterpreter(ModItems.bloodPendant, interpreter);
        registry.registerSubtypeInterpreter(ModItems.flightTiara, (stack, ctx) -> String.valueOf(ItemFlightTiara.getVariant(stack)));
        registry.registerSubtypeInterpreter((Item)ModItems.lexicon, (stack, ctx) -> String.valueOf(ItemNBTHelper.getBoolean(stack, "botania:elven_unlock", false)));
        registry.registerSubtypeInterpreter(ModItems.laputaShard, (stack, ctx) -> String.valueOf(ItemLaputaShard.getShardLevel(stack)));
        registry.registerSubtypeInterpreter(ModItems.terraPick, (stack, ctx) -> {
            if (ctx == UidContext.Recipe) {
                return String.valueOf(ItemTerraPick.isTipped(stack));
            }
            return String.valueOf(ItemTerraPick.getLevel(stack)) + ItemTerraPick.isTipped(stack);
        });
        registry.registerSubtypeInterpreter(ModItems.manaTablet, (stack, ctx) -> {
            int mana = IXplatAbstractions.INSTANCE.findManaItem((ItemStack)stack).getMana();
            return String.valueOf(mana) + ItemManaTablet.isStackCreative(stack);
        });
        for (Item item : new Item[]{ModItems.manaRing, ModItems.manaRingGreater}) {
            registry.registerSubtypeInterpreter(item, (stack, ctx) -> {
                int mana = IXplatAbstractions.INSTANCE.findManaItem((ItemStack)stack).getMana();
                return String.valueOf(mana);
            });
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PureDaisyRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ManaPoolRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new PetalApothecaryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new RunicAltarRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ElvenTradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new BreweryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidIgnemRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new MarimorphosisRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new TerraPlateRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(AncientWillRecipe.class, AncientWillRecipeWrapper::new);
        registration.getCraftingCategory().addCategoryExtension(TerraPickTippingRecipe.class, TerraPickTippingRecipeWrapper::new);
        registration.getCraftingCategory().addCategoryExtension(CompositeLensRecipe.class, CompositeLensRecipeWrapper::new);
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.BREW_TYPE, BY_ID), BreweryRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.PURE_DAISY_TYPE, BY_ID), PureDaisyRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.PETAL_TYPE, BY_ID), PetalApothecaryRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.ELVEN_TRADE_TYPE, BY_ID), ElvenTradeRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.RUNE_TYPE, BY_ID), RunicAltarRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.MANA_INFUSION_TYPE, BY_CATALYST.thenComparing(BY_GROUP).thenComparing(BY_ID)), ManaPoolRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.TERRA_PLATE_TYPE, BY_ID), TerraPlateRecipeCategory.UID);
        Comparator<Recipe<?>> comp = BY_INPUT.thenComparing(BY_WEIGHT).thenComparing(BY_ID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.ORECHID_TYPE, comp), OrechidRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.ORECHID_IGNEM_TYPE, comp), OrechidIgnemRecipeCategory.UID);
        registry.addRecipes(JEIBotaniaPlugin.sortRecipes(ModRecipeTypes.MARIMORPHOSIS_TYPE, comp), MarimorphosisRecipeCategory.UID);
    }

    private static <T extends Recipe<C>, C extends Container> Collection<T> sortRecipes(RecipeType<T> type, Comparator<? super T> comparator) {
        Collection recipes = ModRecipeTypes.getRecipes((Level)Minecraft.m_91087_().f_91073_, type).values();
        ArrayList list = new ArrayList(recipes);
        list.sort(comparator);
        return list;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerCraftingHalo.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.brewery), new ResourceLocation[]{BreweryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.alfPortal), new ResourceLocation[]{ElvenTradeRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.manaPool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.creativePool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.dilutedPool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.fabulousPool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.defaultAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.forestAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.plainsAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.mountainAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.fungalAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.swampAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.desertAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.taigaAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.mesaAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.mossyAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.orechid), new ResourceLocation[]{OrechidRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.orechidFloating), new ResourceLocation[]{OrechidRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.orechidIgnem), new ResourceLocation[]{OrechidIgnemRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.orechidIgnemFloating), new ResourceLocation[]{OrechidIgnemRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.marimorphosis), new ResourceLocation[]{MarimorphosisRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.marimorphosisChibi), new ResourceLocation[]{MarimorphosisRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.marimorphosisFloating), new ResourceLocation[]{MarimorphosisRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.marimorphosisChibiFloating), new ResourceLocation[]{MarimorphosisRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.pureDaisy), new ResourceLocation[]{PureDaisyRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModSubtiles.pureDaisyFloating), new ResourceLocation[]{PureDaisyRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.runeAltar), new ResourceLocation[]{RunicAltarRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.terraPlate), new ResourceLocation[]{TerraPlateRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.autocraftingHalo), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.craftingHalo), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        for (IElvenTradeRecipe recipe : TileAlfPortal.elvenTradeRecipes((Level)Minecraft.m_91087_().f_91073_)) {
            if (recipe instanceof LexiconElvenTradeRecipe) continue;
            NonNullList<Ingredient> inputs = recipe.m_7527_();
            List<ItemStack> outputs = recipe.getOutputs();
            if (inputs.size() != 1 || outputs.size() != 1 || !recipe.containsItem(outputs.get(0))) continue;
            recipeRegistry.hideRecipe((Object)recipe, ElvenTradeRecipeCategory.UID);
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        recipeManager.m_44043_(ResourceLocationHelper.prefix("petal_apothecary/daybloom_motif")).ifPresent(r -> recipeRegistry.hideRecipe(r, PetalApothecaryRecipeCategory.UID));
        recipeManager.m_44043_(ResourceLocationHelper.prefix("petal_apothecary/nightshade_motif")).ifPresent(r -> recipeRegistry.hideRecipe(r, PetalApothecaryRecipeCategory.UID));
        CorporeaInputHandler.hoveredStackGetter = () -> {
            ItemStack stack = (ItemStack)jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse(VanillaTypes.ITEM);
            if (stack == null && Minecraft.m_91087_().f_91080_ == jeiRuntime.getRecipesGui()) {
                stack = (ItemStack)jeiRuntime.getRecipesGui().getIngredientUnderMouse(VanillaTypes.ITEM);
            }
            if (stack == null) {
                stack = (ItemStack)jeiRuntime.getBookmarkOverlay().getIngredientUnderMouse(VanillaTypes.ITEM);
            }
            if (stack != null) {
                return stack;
            }
            return ItemStack.f_41583_;
        };
        CorporeaInputHandler.supportedGuiFilter = gui -> gui instanceof AbstractContainerScreen || gui instanceof IRecipesGui;
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

