/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.mixin.AccessorItemEntity;

public class RenderTileEnchanter
implements BlockEntityRenderer<TileEnchanter> {
    private ItemEntity item;

    public RenderTileEnchanter(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@Nonnull TileEnchanter enchanter, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float alphaMod = 0.0f;
        if (enchanter.stage == TileEnchanter.State.GATHER_MANA) {
            alphaMod = (float)Math.min(20, enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == TileEnchanter.State.RESET) {
            alphaMod = (float)(20 - enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == TileEnchanter.State.DO_ENCHANT) {
            alphaMod = 1.0f;
        }
        ms.m_85836_();
        if (!enchanter.itemToEnchant.m_41619_()) {
            if (this.item == null) {
                this.item = new ItemEntity(enchanter.m_58904_(), (double)enchanter.m_58899_().m_123341_(), (double)(enchanter.m_58899_().m_123342_() + 1), (double)enchanter.m_58899_().m_123343_(), enchanter.itemToEnchant);
            }
            ((AccessorItemEntity)this.item).setAge(ClientTickHandler.ticksInGame);
            this.item.m_32045_(enchanter.itemToEnchant);
            ms.m_85837_(0.5, 1.25, 0.5);
            Minecraft.m_91087_().m_91290_().m_114384_((Entity)this.item, 0.0, 0.0, 0.0, 0.0f, f, ms, buffers, light);
            ms.m_85837_(-0.5, -1.25, -0.5);
        }
        ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        ms.m_85837_(-2.0, -2.0, (double)-0.001f);
        float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 8.0) + 1.0) / 5.0 + 0.4) * alphaMod;
        if (alpha > 0.0f) {
            if (enchanter.stage == TileEnchanter.State.DO_ENCHANT || enchanter.stage == TileEnchanter.State.RESET) {
                int ticks = enchanter.stageTicks + enchanter.stage3EndTicks;
                int angle = ticks * 2;
                float yTranslation = (float)Math.min(20, ticks) / 20.0f * 1.15f;
                float scale = ticks < 10 ? 1.0f : 1.0f - (float)Math.min(20, ticks - 10) / 20.0f * 0.75f;
                ms.m_85837_(2.5, 2.5, (double)(-yTranslation));
                ms.m_85841_(scale, scale, 1.0f);
                ms.m_85845_(Vector3f.f_122227_.m_122240_((float)angle));
                ms.m_85837_(-2.5, -2.5, 0.0);
            }
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.ENCHANTER);
            RenderHelper.renderIcon(ms, buffer, 0, 0, MiscellaneousModels.INSTANCE.enchanterOverlay.m_119204_(), 5, 5, alpha);
        }
        ms.m_85849_();
    }
}

