/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.MathHelper;

public class RenderTilePool
implements BlockEntityRenderer<TilePool> {
    public static int cartMana = -1;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public RenderTilePool(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
    }

    public void render(@Nullable TilePool pool, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        Block below;
        int cap;
        boolean fab;
        ms.m_85836_();
        boolean bl = fab = pool != null && ((BlockPool)pool.m_58900_().m_60734_()).variant == BlockPool.Variant.FABULOUS;
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            time += (float)new Random(pool.m_58899_().m_123341_() ^ pool.m_58899_().m_123342_() ^ pool.m_58899_().m_123343_()).nextInt(100000);
            int poolColor = ColorHelper.getColorValue(pool.getColor());
            int color = MathHelper.multiplyColor(Mth.m_14169_((float)Mth.m_14187_((float)(time *= 0.005f)), (float)0.6f, (float)1.0f), poolColor);
            int red = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int blue = color & 0xFF;
            BlockState state = pool.m_58900_();
            BakedModel model = this.blockRenderDispatcher.m_110910_(state);
            VertexConsumer buffer = buffers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
            this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, state, model, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, light, overlay);
        }
        ms.m_85837_(0.5, 1.5, 0.5);
        int mana = pool == null ? cartMana : pool.getCurrentMana();
        int n = cap = pool == null ? -1 : pool.manaCap;
        if (cap == -1) {
            cap = 1000000;
        }
        float waterLevel = (float)mana / (float)cap * 0.4f;
        float s = 0.0625f;
        float v = 0.125f;
        float w = -v * 3.5f;
        if (pool != null && (below = pool.m_58904_().m_8055_(pool.m_58899_().m_7495_()).m_60734_()) instanceof IPoolOverlayProvider) {
            IPoolOverlayProvider overlayProvider = (IPoolOverlayProvider)below;
            ResourceLocation overlaySpriteId = overlayProvider.getIcon(pool.m_58904_(), pool.m_58899_());
            TextureAtlasSprite overlayIcon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(overlaySpriteId);
            ms.m_85836_();
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2);
            ms.m_85837_(-0.5, -1.4300000667572021, -0.5);
            ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            ms.m_85841_(s, s, s);
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.ICON_OVERLAY);
            RenderHelper.renderIcon(ms, buffer, 0, 0, overlayIcon, 16, 16, alpha);
            ms.m_85849_();
        }
        if (waterLevel > 0.0f) {
            s = 0.0546875f;
            ms.m_85836_();
            ms.m_85837_((double)w, (double)(-1.0f - (0.43f - waterLevel)), (double)w);
            ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            ms.m_85841_(s, s, s);
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.MANA_POOL_WATER);
            RenderHelper.renderIcon(ms, buffer, 0, 0, MiscellaneousModels.INSTANCE.manaWater.m_119204_(), 16, 16, 1.0f);
            ms.m_85849_();
        }
        ms.m_85849_();
        cartMana = -1;
    }
}

