/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class RenderTileRuneAltar
implements BlockEntityRenderer<TileRuneAltar> {
    private final ModelPart spinningCube;
    private static final ResourceLocation cubeTex = ResourceLocationHelper.prefix("textures/block/runic_altar_cube.png");

    public RenderTileRuneAltar(BlockEntityRendererProvider.Context manager) {
        MeshDefinition mesh = new MeshDefinition();
        mesh.m_171576_().m_171599_("cube", CubeListBuilder.m_171558_().m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        this.spinningCube = LayerDefinition.m_171565_((MeshDefinition)mesh, (int)16, (int)16).m_171564_();
    }

    public void render(@Nonnull TileRuneAltar altar, float partticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float scale;
        ms.m_85836_();
        int items = 0;
        for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().m_8020_(i).m_41619_(); ++i) {
            ++items;
        }
        float[] angles = new float[altar.inventorySize()];
        float anglePer = 360.0f / (float)items;
        float totalAngle = 0.0f;
        for (int i = 0; i < angles.length; ++i) {
            angles[i] = totalAngle += anglePer;
        }
        double time = (float)ClientTickHandler.ticksInGame + partticks;
        for (int i = 0; i < altar.inventorySize(); ++i) {
            ms.m_85836_();
            ms.m_85837_(0.5, 1.25, 0.5);
            ms.m_85845_(Vector3f.f_122225_.m_122240_(angles[i] + (float)time));
            ms.m_85837_(1.125, 0.0, 0.25);
            ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            ms.m_85837_(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
            ItemStack stack = altar.getItemHandler().m_8020_(i);
            Minecraft mc = Minecraft.m_91087_();
            if (!stack.m_41619_()) {
                mc.m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, ms, buffers, 0);
            }
            ms.m_85849_();
        }
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        this.renderSpinningCubes(ms, buffers, overlay, 2, 15);
        ms.m_85849_();
        ms.m_85837_(0.0, (double)0.2f, 0.0);
        float f = scale = altar.getTargetMana() == 0 ? 0.0f : (float)altar.getCurrentMana() / (float)altar.getTargetMana() / 75.0f;
        if (scale != 0.0f) {
            int seed = altar.m_58899_().m_123341_() ^ altar.m_58899_().m_123342_() ^ altar.m_58899_().m_123343_();
            ms.m_85837_(0.5, (double)0.7f, 0.5);
            RenderHelper.renderStar(ms, buffers, 58583, scale, scale, scale, seed);
        }
        ms.m_85849_();
    }

    private void renderSpinningCubes(PoseStack ms, MultiBufferSource buffers, int overlay, int cubes, int iters) {
        for (int curIter = iters; curIter > 0; --curIter) {
            float modifier = 6.0f;
            float rotationModifier = 0.2f;
            float radiusBase = 0.35f;
            float radiusMod = 0.05f;
            double ticks = (double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) - 1.3 * (double)(iters - curIter);
            float offsetPerCube = 360 / cubes;
            ms.m_85836_();
            ms.m_85837_((double)-0.025f, (double)0.85f, (double)-0.025f);
            for (int i = 0; i < cubes; ++i) {
                float offset = offsetPerCube * (float)i;
                float deg = (int)(ticks / (double)0.2f % 360.0 + (double)offset);
                float rad = deg * (float)Math.PI / 180.0f;
                float radiusX = (float)((double)0.35f + (double)0.05f * Math.sin(ticks / 6.0));
                float radiusZ = (float)((double)0.35f + (double)0.05f * Math.cos(ticks / 6.0));
                float x = (float)((double)radiusX * Math.cos(rad));
                float z = (float)((double)radiusZ * Math.sin(rad));
                float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                ms.m_85836_();
                ms.m_85837_((double)x, (double)y, (double)z);
                float xRotate = (float)Math.sin(ticks * (double)0.2f) / 2.0f;
                float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                float zRotate = (float)Math.cos(ticks * (double)0.2f) / 2.0f;
                ms.m_85845_(new Vector3f(xRotate, yRotate, zRotate).m_122240_(deg));
                float alpha = 1.0f;
                if (curIter < iters) {
                    alpha = (float)curIter / (float)iters * 0.4f;
                }
                VertexConsumer buffer = buffers.m_6299_(curIter < iters ? RenderType.m_110470_((ResourceLocation)cubeTex) : RenderType.m_110446_((ResourceLocation)cubeTex));
                this.spinningCube.m_104306_(ms, buffer, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, alpha);
                ms.m_85849_();
            }
            ms.m_85849_();
        }
    }
}

