/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfPortalTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("open_elf_portal");
    public static final AlfPortalTrigger INSTANCE = new AlfPortalTrigger();

    private AlfPortalTrigger() {
    }

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @Nonnull
    public Instance createInstance(@Nonnull JsonObject json, EntityPredicate.Composite playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, ItemPredicate.m_45051_((JsonElement)json.get("wand")), LocationPredicate.m_52629_((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, ItemStack wand) {
        this.m_66234_(player, instance -> instance.test(world, pos, wand));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate wand;
        private final LocationPredicate pos;

        public Instance(EntityPredicate.Composite playerPred, ItemPredicate predicate, LocationPredicate pos) {
            super(ID, playerPred);
            this.wand = predicate;
            this.pos = pos;
        }

        @Nonnull
        public ResourceLocation m_7294_() {
            return ID;
        }

        boolean test(ServerLevel world, BlockPos pos, ItemStack wand) {
            return this.wand.m_45049_(wand) && this.pos.m_52617_(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.wand != ItemPredicate.f_45028_) {
                json.add("wand", this.wand.m_45048_());
            }
            if (this.pos != LocationPredicate.f_52592_) {
                json.add("location", this.pos.m_52616_());
            }
            return json;
        }

        public ItemPredicate getWand() {
            return this.wand;
        }

        public LocationPredicate getPos() {
            return this.pos;
        }
    }
}

