/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class BlockAltar
extends BlockMod
implements EntityBlock,
LiquidBlockContainer {
    public static final EnumProperty<IPetalApothecary.State> FLUID = EnumProperty.m_61587_((String)"fluid", IPetalApothecary.State.class);
    private static final VoxelShape BASE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape PILLAR = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape TOP = Block.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape TOP_CUTOUT = Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)PILLAR), (VoxelShape)Shapes.m_83113_((VoxelShape)TOP, (VoxelShape)TOP_CUTOUT, (BooleanOp)BooleanOp.f_82685_));
    public final Variant variant;

    public boolean m_6044_(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Fluid fluid) {
        return state.m_61143_(FLUID) == IPetalApothecary.State.EMPTY && fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(@Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluidState) {
        if (this.m_6044_((BlockGetter)level, pos, state, fluidState.m_76152_())) {
            level.m_7731_(pos, (BlockState)state.m_61124_(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)), 3);
            return true;
        }
        return false;
    }

    protected BlockAltar(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FLUID, (Comparable)((Object)IPetalApothecary.State.EMPTY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FLUID});
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            TileAltar tile = (TileAltar)world.m_7702_(pos);
            if (tile.collideEntityItem(itemEntity)) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof TileAltar)) {
            return InteractionResult.PASS;
        }
        TileAltar apothecary = (TileAltar)blockEntity;
        boolean mainHandEmpty = player.m_21205_().m_41619_();
        if (apothecary.canAddLastRecipe() && mainHandEmpty) {
            apothecary.trySetLastRecipe(player);
            return InteractionResult.SUCCESS;
        }
        if (!apothecary.isEmpty() && mainHandEmpty) {
            InventoryHelper.withdrawFromInventory(apothecary, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(apothecary);
            return InteractionResult.SUCCESS;
        }
        if (this.tryWithdrawFluid(player, hand, apothecary, pos) || this.tryDepositFluid(player, hand, apothecary, pos)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (world.f_46441_.nextInt(20) == 1 && state.m_61143_(FLUID) == IPetalApothecary.State.EMPTY) {
            world.m_46597_(pos, (BlockState)state.m_61124_(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)));
        }
    }

    private boolean tryWithdrawFluid(Player player, InteractionHand hand, TileAltar altar, BlockPos pos) {
        Fluid fluid = altar.getFluid().asVanilla();
        if (fluid == Fluids.f_76191_ || fluid == Fluids.f_76193_ && IXplatAbstractions.INSTANCE.gogLoaded()) {
            return false;
        }
        boolean success = IXplatAbstractions.INSTANCE.insertFluidIntoPlayerItem(player, hand, fluid);
        if (success) {
            altar.setFluid(IPetalApothecary.State.EMPTY);
            if (fluid == Fluids.f_76193_) {
                player.f_19853_.m_5594_(player, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (fluid == Fluids.f_76195_) {
                player.f_19853_.m_5594_(player, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return success;
    }

    private boolean tryDepositFluid(Player player, InteractionHand hand, TileAltar altar, BlockPos pos) {
        if (altar.getFluid() != IPetalApothecary.State.EMPTY) {
            return false;
        }
        if (IXplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.f_76193_)) {
            altar.setFluid(IPetalApothecary.State.WATER);
            player.f_19853_.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (IXplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.f_76195_)) {
            altar.setFluid(IPetalApothecary.State.LAVA);
            player.f_19853_.m_5594_(player, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileAltar(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::clientTick);
        }
        return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::serverTick);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        boolean blockChanged;
        boolean bl = blockChanged = !state.m_60713_(newState.m_60734_());
        if (blockChanged || newState.m_61143_(FLUID) != IPetalApothecary.State.WATER) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            if (blockChanged) {
                super.m_6810_(state, world, pos, newState, isMoving);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return state.m_61143_(FLUID) == IPetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY;

    }
}

