/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.mixin.AccessorRecipeManager;

public class BlockTerraPlate
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockTerraPlate.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public BlockTerraPlate(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && BlockTerraPlate.usesItem(stack, world)) {
            if (!world.f_46443_) {
                ItemStack target = stack.m_41620_(1);
                ItemEntity item = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, target);
                item.m_32010_(40);
                item.m_20256_(Vec3.f_82478_);
                world.m_7967_((Entity)item);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean usesItem(ItemStack stack, Level world) {
        for (Recipe value : ((AccessorRecipeManager)world.m_7465_()).botania_getAll(ModRecipeTypes.TERRA_PLATE_TYPE).values()) {
            for (Ingredient i : value.m_7527_()) {
                if (!i.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileTerraPlate(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_) {
            return BlockTerraPlate.createTickerHelper(type, ModTiles.TERRA_PLATE, TileTerraPlate::serverTick);
        }
        return null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        TileTerraPlate plate = (TileTerraPlate)world.m_7702_(pos);
        return plate.getComparatorLevel();
    }
}

