/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileEntropinnyum
extends TileEntityGeneratingFlower {
    private static final int RANGE = 12;
    private static final int EXPLODE_EFFECT_EVENT = 0;
    private static final int ANGRY_EFFECT_EVENT = 1;

    public SubTileEntropinnyum(BlockPos pos, BlockState state) {
        super(ModSubtiles.ENTROPINNYUM, pos, state);
    }

    public static boolean isUnethical(Entity e) {
        BlockPos center = e.m_142538_();
        if (!e.f_19853_.m_46749_(center)) {
            return false;
        }
        int x = center.m_123341_();
        int y = center.m_123342_();
        int z = center.m_123343_();
        int range = 3;
        int movingPistons = 0;
        int rails = 0;
        int slimes = 0;
        for (BlockPos pos : BlockPos.m_121976_((int)(x - range), (int)(y - range), (int)(z - range), (int)(x + range + 1), (int)(y + range + 1), (int)(z + range + 1))) {
            BlockState state = e.f_19853_.m_8055_(pos);
            if (state.m_60713_(Blocks.f_50110_)) {
                ++movingPistons;
                BlockEntity te = e.f_19853_.m_7702_(pos);
                if (te instanceof PistonMovingBlockEntity) {
                    PistonMovingBlockEntity piston = (PistonMovingBlockEntity)te;
                    state = piston.m_60400_();
                }
            }
            if (state.m_60734_() instanceof DetectorRailBlock) {
                ++rails;
            } else if (state.m_60734_() instanceof SlimeBlock || state.m_60734_() instanceof HoneyBlock) {
                ++slimes;
            }
            if (movingPistons <= 0 || rails <= 0 || slimes <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.getMana() == 0) {
            List tnts = this.m_58904_().m_45976_(PrimedTnt.class, new AABB(this.getEffectivePos().m_142082_(-12, -12, -12), this.getEffectivePos().m_142082_(13, 13, 13)));
            for (PrimedTnt tnt : tnts) {
                FluidState fluid = this.m_58904_().m_6425_(tnt.m_142538_());
                if (tnt.m_32100_() != 1 || !tnt.m_6084_() || !fluid.m_76178_()) continue;
                boolean unethical = IXplatAbstractions.INSTANCE.ethicalComponent(tnt).isUnethical();
                tnt.m_5496_(unethical ? ModSounds.entropinnyumAngry : ModSounds.entropinnyumHappy, 1.0f, (1.0f + (this.m_58904_().f_46441_.nextFloat() - this.m_58904_().f_46441_.nextFloat()) * 0.2f) * 0.7f);
                tnt.m_146870_();
                this.addMana(unethical ? 3 : this.getMaxMana());
                this.sync();
                this.m_58904_().m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), unethical ? 1 : 0, tnt.m_142049_());
                break;
            }
        }
    }

    public boolean m_7531_(int event, int param) {
        if (event == 0) {
            if (this.m_58904_().f_46443_ && this.m_58904_().m_6815_(param) instanceof PrimedTnt) {
                Entity e = this.m_58904_().m_6815_(param);
                for (int i = 0; i < 50; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle((float)(Math.random() * (double)0.65f + 1.25), 1.0f, (float)Math.random() * 0.25f, (float)Math.random() * 0.25f, 12);
                    this.f_58857_.m_7106_((ParticleOptions)data, e.m_20185_() + Math.random() * 4.0 - 2.0, e.m_20186_() + Math.random() * 4.0 - 2.0, e.m_20189_() + Math.random() * 4.0 - 2.0, 0.0, 0.0, 0.0);
                }
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 1.0, 0.0, 0.0);
            }
            return true;
        }
        if (event == 1) {
            if (this.m_58904_().f_46443_ && this.m_58904_().m_6815_(param) instanceof PrimedTnt) {
                Entity e = this.m_58904_().m_6815_(param);
                for (int i = 0; i < 50; ++i) {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, e.m_20185_() + Math.random() * 4.0 - 2.0, e.m_20186_() + Math.random() * 4.0 - 2.0, e.m_20189_() + Math.random() * 4.0 - 2.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.m_7531_(event, param);
    }

    @Override
    public int getColor() {
        return 0xCB0000;
    }

    @Override
    public int getMaxMana() {
        return 6500;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 12);
    }
}

