/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.handler.ModSounds;

public class SubTileShulkMeNot
extends TileEntityGeneratingFlower {
    private static final int RADIUS = 8;

    public SubTileShulkMeNot(BlockPos pos, BlockState state) {
        super(ModSubtiles.SHULK_ME_NOT, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        int generate = this.getMaxMana();
        Level world = this.m_58904_();
        BlockPos pos = this.getEffectivePos();
        Vec3 posD = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (!world.f_46443_) {
            List shulkers = world.m_45976_(Shulker.class, new AABB(pos).m_82400_(8.0));
            for (Shulker shulker : shulkers) {
                LivingEntity target;
                if (this.getMaxMana() - this.getMana() < generate) break;
                if (!shulker.m_6084_() || !(shulker.m_20238_(posD) < 64.0) || !((target = shulker.m_5448_()) instanceof Enemy) || !target.m_6084_() || !(target.m_20238_(posD) < 64.0) || target.m_21124_(MobEffects.f_19620_) == null) continue;
                target.m_146870_();
                shulker.m_146870_();
                for (int i = 0; i < 10; ++i) {
                    world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, ModSounds.shulkMeNot, SoundSource.BLOCKS, 10.0f, 1.0f);
                }
                this.particles(world, pos, (Entity)target);
                this.particles(world, pos, (Entity)shulker);
                this.addMana(generate);
                this.sync();
            }
        }
    }

    private void particles(Level world, BlockPos pos, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            ws.m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_() + (double)(entity.m_20205_() / 2.0f), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_() + (double)(entity.m_20205_() / 2.0f), 100, (double)entity.m_20205_(), (double)entity.m_20206_(), (double)entity.m_20205_(), 0.05);
            ws.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 40, 0.0, 0.0, 0.0, 0.6);
        }
    }

    @Override
    public int getColor() {
        return 8476056;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 8.0);
    }

    @Override
    public int getMaxMana() {
        return 75000;
    }
}

