/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class RecipeManaInfusion
implements IManaInfusionRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient input;
    private final int mana;
    @Nullable
    private final StateIngredient catalyst;
    private final String group;

    public RecipeManaInfusion(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group, @Nullable StateIngredient catalyst) {
        Preconditions.checkArgument((mana > 0 ? 1 : 0) != 0, (Object)"Mana cost must be positive");
        Preconditions.checkArgument((mana <= 1000001 ? 1 : 0) != 0, (Object)"Mana cost must be at most a pool");
        this.id = id;
        this.output = output;
        this.input = input;
        this.mana = mana;
        this.group = group == null ? "" : group;
        this.catalyst = catalyst;
    }

    @Deprecated
    public RecipeManaInfusion(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group, @Nullable BlockState catalystState) {
        this(id, output, input, mana, group, StateIngredientHelper.of(catalystState));
    }

    @Nonnull
    public final ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<RecipeManaInfusion> m_7707_() {
        return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    public StateIngredient getRecipeCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getManaToConsume() {
        return this.mana;
    }

    @Override
    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    @Nonnull
    public String m_6076_() {
        return this.group;
    }

    @Nonnull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.manaPool);
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeManaInfusion> {
        @Nonnull
        public RecipeManaInfusion fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            JsonElement input = Objects.requireNonNull(json.get("input"));
            Ingredient ing = Ingredient.m_43917_((JsonElement)input);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            int mana = GsonHelper.m_13927_((JsonObject)json, (String)"mana");
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            StateIngredient catalyst = null;
            if (json.has("catalyst")) {
                JsonElement element = json.get("catalyst");
                if (!element.isJsonObject() || !element.getAsJsonObject().has("type")) {
                    throw new JsonParseException("Legacy mana infusion catalyst syntax used");
                }
                catalyst = StateIngredientHelper.deserialize(element.getAsJsonObject());
            }
            return new RecipeManaInfusion(id, output, ing, mana, group, catalyst);
        }

        @Nullable
        public RecipeManaInfusion fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            int mana = buf.m_130242_();
            StateIngredient catalyst = null;
            if (buf.readBoolean()) {
                catalyst = StateIngredientHelper.read(buf);
            }
            String group = buf.m_130277_();
            return new RecipeManaInfusion(id, output, input, mana, group, catalyst);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull RecipeManaInfusion recipe) {
            ((Ingredient)recipe.m_7527_().get(0)).m_43923_(buf);
            buf.m_130055_(recipe.m_8043_());
            buf.m_130130_(recipe.getManaToConsume());
            boolean hasCatalyst = recipe.getRecipeCatalyst() != null;
            buf.writeBoolean(hasCatalyst);
            if (hasCatalyst) {
                recipe.getRecipeCatalyst().write(buf);
            }
            buf.m_130070_(recipe.m_6076_());
        }
    }
}

