/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ModItems;

public class ManaGunRemoveLensRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<ManaGunRemoveLensRecipe> SERIALIZER = new SimpleRecipeSerializer(ManaGunRemoveLensRecipe::new);

    public ManaGunRemoveLensRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundGun = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemManaGun && !ItemManaGun.getLens(stack).m_41619_()) {
                foundGun = true;
                continue;
            }
            return false;
        }
        return foundGun;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack gun = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemManaGun)) continue;
            gun = stack;
        }
        ItemStack gunCopy = gun.m_41777_();
        gunCopy.m_41764_(1);
        ItemManaGun.setLens(gunCopy, ItemStack.f_41583_);
        return gunCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            if (s.m_150930_(ModItems.manaGun)) {
                ItemStack stack = ItemManaGun.getLens(s);
                stack.m_41764_(1);
                return stack;
            }
            return null;
        });
    }
}

