/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

public class TerraPickTippingRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<TerraPickTippingRecipe> SERIALIZER = new SimpleRecipeSerializer(TerraPickTippingRecipe::new);

    public TerraPickTippingRecipe(ResourceLocation id) {
        super(id);
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundTerraPick = false;
        boolean foundElementiumPick = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemTerraPick && !ItemTerraPick.isTipped(stack)) {
                foundTerraPick = true;
                continue;
            }
            if (stack.m_150930_(ModItems.elementiumPick)) {
                foundElementiumPick = true;
                continue;
            }
            return false;
        }
        return foundTerraPick && foundElementiumPick;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack terraPick = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemTerraPick)) continue;
            terraPick = stack;
        }
        if (terraPick.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack terraPickCopy = terraPick.m_41777_();
        ItemTerraPick.setTipped(terraPickCopy);
        return terraPickCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }
}

