/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemKeepIvy
extends Item {
    public static final String TAG_KEEP = "Botania_keepIvy";
    public static final String TAG_PLAYER_KEPT_DROPS = "Botania_playerKeptDrops";
    private static final String TAG_DROP_COUNT = "dropCount";
    private static final String TAG_DROP_PREFIX = "dropPrefix";

    public ItemKeepIvy(Item.Properties props) {
        super(props);
    }

    public static boolean hasIvy(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && ItemNBTHelper.getBoolean(stack, TAG_KEEP, false);
    }

    public static void keepDropsOnDeath(Player player) {
        ArrayList<ItemStack> keeps = new ArrayList<ItemStack>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !stack.m_41782_() || !ItemNBTHelper.getBoolean(stack, TAG_KEEP, false)) continue;
            keeps.add(stack);
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
        KeptItemsComponent data = IXplatAbstractions.INSTANCE.keptItemsComponent(player, false);
        data.addAll(keeps);
    }

    public static void onPlayerRespawn(Player oldPlayer, Player newPlayer, boolean alive) {
        if (!alive) {
            KeptItemsComponent keeps = IXplatAbstractions.INSTANCE.keptItemsComponent(oldPlayer, true);
            for (ItemStack stack : keeps.getStacks()) {
                ItemStack copy = stack.m_41777_();
                copy.m_41749_(TAG_KEEP);
                if (newPlayer.m_150109_().m_36054_(copy)) continue;
                newPlayer.m_19983_(copy);
            }
        }
    }
}

