/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ItemModPattern;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.api.PatchouliAPI;

public class ItemLexicon
extends ItemModPattern {
    public static final String TAG_ELVEN_UNLOCK = "botania:elven_unlock";

    public ItemLexicon(Item.Properties settings) {
        super(settings);
    }

    public static boolean isOpen() {
        return Registry.f_122827_.m_7981_((Object)ModItems.lexicon).equals((Object)PatchouliAPI.get().getOpenBookGui());
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            list.add((Object)new ItemStack((ItemLike)this));
            ItemStack creative = new ItemStack((ItemLike)this);
            creative.m_41784_().m_128379_(TAG_ELVEN_UNLOCK, true);
            list.add((Object)creative);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)ItemLexicon.getEdition().m_6881_().m_130940_(ChatFormatting.GRAY));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.m_183503_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
            PatchouliAPI.get().openBookGUI((ServerPlayer)playerIn, Registry.f_122827_.m_7981_((Object)this));
            playerIn.m_5496_(ModSounds.lexiconOpen, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static Component getEdition() {
        try {
            return PatchouliAPI.get().getSubtitle(Registry.f_122827_.m_7981_((Object)ModItems.lexicon));
        }
        catch (IllegalArgumentException e) {
            return new TextComponent("");
        }
    }

    public static Component getTitle(ItemStack stack) {
        Component title = stack.m_41786_();
        String akashicTomeNBT = "akashictome:displayName";
        if (stack.m_41782_() && stack.m_41783_().m_128441_(akashicTomeNBT)) {
            title = Component.Serializer.m_130701_((String)stack.m_41783_().m_128461_(akashicTomeNBT));
        }
        return title;
    }

    public static boolean isElven(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(TAG_ELVEN_UNLOCK);
    }

    public static BlockHitResult doRayTrace(Level world, Player player, ClipContext.Fluid fluidMode) {
        return Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)fluidMode);
    }
}

