/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.proxy.IProxy;

public class ItemTinyPlanet
extends ItemBauble {
    public ItemTinyPlanet(Item.Properties props) {
        super(props);
        IProxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        double x = living.m_20185_();
        double y = living.m_20186_() + (double)living.m_20192_();
        double z = living.m_20189_();
        ItemTinyPlanet.applyEffect(living.f_19853_, x, y, z);
    }

    public static void applyEffect(Level world, double x, double y, double z) {
        int range = 8;
        List entities = world.m_6443_(ThrowableProjectile.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range), (Predicate)Predicates.instanceOf(IManaBurst.class));
        for (ThrowableProjectile entity : entities) {
            ITinyPlanetExcempt excempt;
            Item item;
            IManaBurst burst = (IManaBurst)entity;
            ItemStack lens = burst.getSourceLens();
            if (lens != null && (item = lens.m_41720_()) instanceof ITinyPlanetExcempt && !(excempt = (ITinyPlanetExcempt)item).shouldPull(lens)) continue;
            int orbitTime = burst.getOrbitTime();
            if (orbitTime == 0) {
                burst.setMinManaLoss(burst.getMinManaLoss() * 3);
            }
            float radius = Math.min(7.5f, (float)(Math.max(40, orbitTime) - 40) / 40.0f + 1.5f);
            int angle = orbitTime % 360;
            float xTarget = (float)(x + Math.cos((double)(angle * 10) * Math.PI / 180.0) * (double)radius);
            float yTarget = (float)y;
            float zTarget = (float)(z + Math.sin((double)(angle * 10) * Math.PI / 180.0) * (double)radius);
            Vec3 targetVec = new Vec3((double)xTarget, (double)yTarget, (double)zTarget);
            Vec3 currentVec = entity.m_20182_();
            Vec3 moveVector = targetVec.m_82546_(currentVec);
            entity.m_20256_(moveVector);
            burst.setOrbitTime(burst.getOrbitTime() + 1);
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(-0.25, -0.4, 0.0);
            ms.m_85841_(0.5f, -0.5f, -0.5f);
            Minecraft.m_91087_().m_91289_().m_110912_(ModBlocks.tinyPlanet.m_49966_(), ms, buffers, light, OverlayTexture.f_118083_);
        }
    }
}

