/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.EntityBabylonWeapon;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemKingKey
extends ItemRelic {
    private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
    private static final String TAG_CHARGING = "charging";
    public static final int WEAPON_TYPES = 12;

    public ItemKingKey(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemKingKey.setCharging(stack, true);
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int time) {
        int spawned = ItemKingKey.getWeaponsSpawned(stack);
        if (spawned == 20) {
            ItemKingKey.setCharging(stack, false);
            ItemKingKey.setWeaponsSpawned(stack, 0);
        }
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int count) {
        block5: {
            int spawned;
            block6: {
                spawned = ItemKingKey.getWeaponsSpawned(stack);
                if (count == this.m_8105_(stack) || spawned >= 20 || world.f_46443_) break block5;
                if (!(living instanceof Player)) break block6;
                Player player = (Player)living;
                if (!ManaItemHandler.instance().requestManaExact(stack, player, 150, true)) break block5;
            }
            Vec3 look = living.m_20154_().m_82542_(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(living.m_146908_() + 90.0f);
            if (look.f_82479_ == 0.0 && look.f_82481_ == 0.0) {
                look = new Vec3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.m_82541_().m_82490_(-2.0);
            int div = spawned / 5;
            int mod = spawned % 5;
            Vec3 pl = look.m_82549_(VecHelper.fromEntityCenter((Entity)living)).m_82520_(0.0, 1.6, (double)div * 0.1);
            Random rand = world.f_46441_;
            Vec3 axis = look.m_82541_().m_82537_(new Vec3(-1.0, 0.0, -1.0)).m_82541_();
            double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
            Vec3 axis1 = VecHelper.rotate(axis.m_82490_((double)div * 3.5 + 5.0), rot, look);
            if (axis1.f_82480_ < 0.0) {
                axis1 = axis1.m_82542_(1.0, -1.0, 1.0);
            }
            Vec3 end = pl.m_82549_(axis1);
            EntityBabylonWeapon weapon = new EntityBabylonWeapon(living, world);
            weapon.m_6034_(end.f_82479_, end.f_82480_, end.f_82481_);
            weapon.m_146922_(living.m_146908_());
            weapon.setVariety(rand.nextInt(12));
            weapon.setDelay(spawned);
            weapon.setRotation(Mth.m_14177_((float)(-living.m_146908_() + 180.0f)));
            world.m_7967_((Entity)weapon);
            weapon.m_5496_(ModSounds.babylonSpawn, 1.0f, 1.0f + world.f_46441_.nextFloat() * 3.0f);
            ItemKingKey.setWeaponsSpawned(stack, spawned + 1);
        }
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public static boolean isCharging(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
    }

    public static int getWeaponsSpawned(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
    }

    public static void setCharging(ItemStack stack, boolean charging) {
        ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
    }

    public static void setWeaponsSpawned(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
    }

    public static IRelic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/king_key"));
    }
}

