/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeData
extends TileDataShim {
    protected final ItemStack[] upgrades;
    private int storageMultiplier;
    private EnumUpgradeRedstone redstoneType;
    private boolean hasOneStack;
    private boolean hasVoid;
    private boolean hasUnlimited;
    private boolean hasVending;
    private boolean hasConversion;
    private boolean hasIllumination;
    private boolean hasFillLevel;
    private IDrawerAttributesModifiable attrs;

    public UpgradeData(int slotCount) {
        this.upgrades = new ItemStack[slotCount];
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = ItemStack.f_41583_;
        }
        this.syncStorageMultiplier();
    }

    public void setDrawerAttributes(IDrawerAttributesModifiable attrs) {
        this.attrs = attrs;
        this.syncUpgrades();
    }

    public int getSlotCount() {
        return this.upgrades.length;
    }

    @Nonnull
    public ItemStack getUpgrade(int slot) {
        slot = Mth.m_14045_((int)slot, (int)0, (int)(this.upgrades.length - 1));
        return this.upgrades[slot];
    }

    public boolean hasEmptySlot() {
        return this.getNextUpgradeSlot() != -1;
    }

    public boolean addUpgrade(@Nonnull ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public boolean setUpgrade(int slot, @Nonnull ItemStack upgrade) {
        ItemStack prevUpgrade;
        slot = Mth.m_14045_((int)slot, (int)0, (int)(this.upgrades.length - 1));
        if (!upgrade.m_41619_()) {
            upgrade = upgrade.m_41777_();
            upgrade.m_41764_(1);
        }
        if (!(prevUpgrade = this.upgrades[slot]).m_41619_() && !this.canRemoveUpgrade(slot)) {
            return false;
        }
        this.upgrades[slot] = ItemStack.f_41583_;
        this.syncStorageMultiplier();
        if (!upgrade.m_41619_() && !this.canAddUpgrade(upgrade)) {
            this.upgrades[slot] = prevUpgrade;
            this.syncStorageMultiplier();
            return false;
        }
        this.upgrades[slot] = upgrade;
        this.syncUpgrades();
        this.onUpgradeChanged(prevUpgrade, upgrade);
        return true;
    }

    public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
        if (upgrade.m_41619_()) {
            return false;
        }
        if (!(upgrade.m_41720_() instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)upgrade.m_41720_();
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemUpgrade)) continue;
            ItemUpgrade reference = (ItemUpgrade)stack.m_41720_();
            if (candidate.getUpgradeGroup() != reference.getUpgradeGroup()) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveUpgrade(int slot) {
        return !this.upgrades[slot = Mth.m_14045_((int)slot, (int)0, (int)(this.upgrades.length - 1))].m_41619_();
    }

    public int getStorageMultiplier() {
        return this.storageMultiplier;
    }

    public EnumUpgradeRedstone getRedstoneType() {
        return this.redstoneType;
    }

    public boolean hasOneStackUpgrade() {
        return this.hasOneStack;
    }

    public boolean hasUnlimitedUpgrade() {
        return this.hasUnlimited;
    }

    public boolean hasVendingUpgrade() {
        return this.hasVending;
    }

    public boolean hasConversionUpgrade() {
        return this.hasConversion;
    }

    public boolean hasIlluminationUpgrade() {
        return this.hasIllumination;
    }

    private int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private void syncUpgrades() {
        if (this.attrs == null) {
            return;
        }
        this.syncStorageMultiplier();
        this.syncRedstoneLevel();
        this.hasOneStack = false;
        this.hasVoid = false;
        this.hasUnlimited = false;
        this.hasVending = false;
        this.hasConversion = false;
        this.hasIllumination = false;
        this.hasFillLevel = false;
        for (ItemStack stack : this.upgrades) {
            Item item = stack.m_41720_();
            if (item == ModItems.ONE_STACK_UPGRADE.get()) {
                this.hasOneStack = true;
                continue;
            }
            if (item == ModItems.VOID_UPGRADE.get()) {
                this.hasVoid = true;
                continue;
            }
            if (item == ModItems.CONVERSION_UPGRADE.get()) {
                this.hasConversion = true;
                continue;
            }
            if (item == ModItems.CREATIVE_STORAGE_UPGRADE.get()) {
                this.hasUnlimited = true;
                continue;
            }
            if (item == ModItems.CREATIVE_VENDING_UPGRADE.get()) {
                this.hasVending = true;
                continue;
            }
            if (item == ModItems.ILLUMINATION_UPGRADE.get()) {
                this.hasIllumination = true;
                continue;
            }
            if (item != ModItems.FILL_LEVEL_UPGRADE.get()) continue;
            this.hasFillLevel = true;
        }
        this.attrs.setIsVoid(this.hasVoid);
        this.attrs.setHasFillLevel(this.hasFillLevel);
        this.attrs.setIsDictConvertible(this.hasConversion);
        this.attrs.setIsUnlimitedStorage(this.hasUnlimited);
        this.attrs.setIsUnlimitedVending(this.hasVending);
    }

    private void syncStorageMultiplier() {
        this.storageMultiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.m_41720_() instanceof ItemUpgradeStorage)) continue;
            int level = ((ItemUpgradeStorage)stack.m_41720_()).level.getLevel();
            this.storageMultiplier += CommonConfig.UPGRADES.getLevelMult(level);
        }
        if (this.storageMultiplier == 0) {
            this.storageMultiplier = CommonConfig.UPGRADES.getLevelMult(0);
        }
    }

    private void syncRedstoneLevel() {
        this.redstoneType = null;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.m_41720_() instanceof ItemUpgradeRedstone)) continue;
            this.redstoneType = ((ItemUpgradeRedstone)stack.m_41720_()).type;
            break;
        }
    }

    @Override
    public void read(CompoundTag tag) {
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = ItemStack.f_41583_;
        }
        if (!tag.m_128441_("Upgrades")) {
            return;
        }
        ListTag tagList = tag.m_128437_("Upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag upgradeTag = tagList.m_128728_(i);
            byte slot = upgradeTag.m_128445_("Slot");
            this.upgrades[slot] = ItemStack.m_41712_((CompoundTag)upgradeTag);
        }
        this.syncUpgrades();
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i].m_41619_()) continue;
            CompoundTag upgradeTag = this.upgrades[i].m_41739_(new CompoundTag());
            upgradeTag.m_128344_("Slot", (byte)i);
            tagList.add((Object)upgradeTag);
        }
        tag.m_128365_("Upgrades", (Tag)tagList);
        return tag;
    }

    protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
    }
}

