/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class WirelessTransmitterNetworkNode
extends NetworkNode
implements IWirelessTransmitter {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "wireless_transmitter");
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.RANGE).addListener(new NetworkNodeInventoryListener(this));

    public WirelessTransmitterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getWirelessTransmitter().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 0, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 0, tag);
        return tag;
    }

    @Override
    public int getRange() {
        return RS.SERVER_CONFIG.getWirelessTransmitter().getBaseRange() + this.upgrades.getUpgradeCount(UpgradeItem.Type.RANGE) * RS.SERVER_CONFIG.getWirelessTransmitter().getRangePerUpgrade();
    }

    @Override
    public BlockPos getOrigin() {
        return this.pos;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.level.m_46472_();
    }

    public BaseItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    @Override
    public boolean canConduct(Direction direction) {
        return this.getDirection() == direction;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        operator.apply(this.level, this.pos.m_142300_(Direction.DOWN), Direction.UP);
    }
}

