/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.factory.FluidStorageDiskFactory;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageDisk
implements IStorageDisk<FluidStack> {
    public static final String NBT_VERSION = "Version";
    public static final String NBT_CAPACITY = "Capacity";
    public static final String NBT_FLUIDS = "Fluids";
    public static final String NBT_OWNER = "Owner";
    public static final int VERSION = 1;
    @Nullable
    private final ServerLevel level;
    private final int capacity;
    private final Multimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();
    private final UUID owner;
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public FluidStorageDisk(@Nullable ServerLevel level, int capacity, @Nullable UUID owner) {
        this.level = level;
        this.capacity = capacity;
        this.owner = owner;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (FluidStack stack : this.stacks.values()) {
            list.add((Object)stack.writeToNBT(new CompoundTag()));
        }
        tag.m_128405_(NBT_VERSION, 1);
        tag.m_128365_(NBT_FLUIDS, (Tag)list);
        tag.m_128405_(NBT_CAPACITY, this.capacity);
        if (this.owner != null) {
            tag.m_128362_(NBT_OWNER, this.owner);
        }
        return tag;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!otherStack.isFluidEqual(stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return StackUtils.copy(stack, size);
                }
                if (action == Action.PERFORM) {
                    otherStack.grow(remainingSpace);
                    this.onChanged();
                }
                return StackUtils.copy(otherStack, size - remainingSpace);
            }
            int maxConsumable = Math.min(size, Integer.MAX_VALUE - otherStack.getAmount());
            if (action == Action.PERFORM) {
                otherStack.grow(maxConsumable);
                this.onChanged();
            }
            return StackUtils.copy(otherStack, size - maxConsumable);
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return StackUtils.copy(stack, size);
            }
            if (action == Action.PERFORM) {
                this.stacks.put((Object)stack.getFluid(), (Object)StackUtils.copy(stack, remainingSpace));
                this.onChanged();
            }
            return StackUtils.copy(stack, size - remainingSpace);
        }
        if (action == Action.PERFORM) {
            this.stacks.put((Object)stack.getFluid(), (Object)StackUtils.copy(stack, size));
            this.onChanged();
        }
        return FluidStack.EMPTY;
    }

    @Override
    @Nonnull
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.getAmount()) {
                size = otherStack.getAmount();
            }
            if (action == Action.PERFORM) {
                if (otherStack.getAmount() - size == 0) {
                    this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
                } else {
                    otherStack.shrink(size);
                }
                this.onChanged();
            }
            return StackUtils.copy(otherStack, size);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getStored() {
        return this.stacks.values().stream().mapToInt(FluidStack::getAmount).sum();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.getAmount();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public ResourceLocation getFactoryId() {
        return FluidStorageDiskFactory.ID;
    }

    public Multimap<Fluid, FluidStack> getRawStacks() {
        return this.stacks;
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        if (this.level != null) {
            API.instance().getStorageDiskManager(this.level).markForSaving();
        }
    }
}

