/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NetworkNodeBlockEntity<N extends NetworkNode>
extends BaseBlockEntity
implements INetworkNodeProxy<N>,
IRedstoneConfigurable {
    public static final BlockEntitySynchronizationParameter<Integer, NetworkNodeBlockEntity> REDSTONE_MODE = RedstoneMode.createParameter();
    private final LazyOptional<INetworkNodeProxy<N>> networkNodeProxy = LazyOptional.of(() -> this);
    private final Class<N> networkNodeClass;
    private N clientNode;
    private N removedNode;
    private static final Logger LOGGER = LogManager.getLogger();

    @Deprecated
    protected NetworkNodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, null);
    }

    protected NetworkNodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Class<N> networkNodeClass) {
        super(type, pos, state);
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.networkNodeClass = networkNodeClass;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return ((NetworkNode)this.getNode()).getRedstoneMode();
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        ((NetworkNode)this.getNode()).setRedstoneMode(mode);
    }

    @Override
    @Nonnull
    public N getNode() {
        if (this.f_58857_.f_46443_) {
            if (this.clientNode == null) {
                this.clientNode = this.createNode(this.f_58857_, this.f_58858_);
            }
            return this.clientNode;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerLevel)this.f_58857_);
        try {
            INetworkNode node = manager.getNode(this.f_58858_);
            if (node == null) {
                LOGGER.warn("Expected a node @ {} but couldn't find it, creating a new one...", (Object)this.f_58858_);
                node = this.createAndSetNode(manager);
            }
            return this.doCast(node);
        }
        catch (ClassCastException e) {
            LOGGER.warn("Node @ {} got desynced with it's block entity container, recreating", (Object)this.f_58858_, (Object)e);
            return (N)((NetworkNode)this.createAndSetNode(manager));
        }
    }

    private N doCast(INetworkNode node) {
        if (this.networkNodeClass == null) {
            return (N)((NetworkNode)node);
        }
        return (N)((NetworkNode)this.networkNodeClass.cast(node));
    }

    private INetworkNode createAndSetNode(INetworkNodeManager manager) {
        N node = this.createNode(this.f_58857_, this.f_58858_);
        manager.setNode(this.f_58858_, (INetworkNode)node);
        manager.markForSaving();
        return node;
    }

    public void m_6339_() {
        INetworkNodeManager manager;
        super.m_6339_();
        if (!this.f_58857_.f_46443_ && (manager = API.instance().getNetworkNodeManager((ServerLevel)this.f_58857_)).getNode(this.f_58858_) == null) {
            manager.setNode(this.f_58858_, (INetworkNode)this.createNode(this.f_58857_, this.f_58858_));
            manager.markForSaving();
        }
    }

    @Override
    public void onRemovedNotDueToChunkUnload() {
        super.onRemovedNotDueToChunkUnload();
        if (!this.f_58857_.f_46443_) {
            INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerLevel)this.f_58857_);
            INetworkNode node = manager.getNode(this.f_58858_);
            if (node != null) {
                try {
                    this.removedNode = this.doCast(node);
                }
                catch (ClassCastException e) {
                    this.removedNode = null;
                }
            }
            manager.removeNode(this.f_58858_);
            manager.markForSaving();
            if (node != null && node.getNetwork() != null) {
                node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().getLevel(), node.getNetwork().getPosition());
            }
        }
    }

    public N getRemovedNode() {
        return this.removedNode;
    }

    public abstract N createNode(Level var1, BlockPos var2);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY) {
            return this.networkNodeProxy.cast();
        }
        return super.getCapability(cap, direction);
    }
}

