/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container.transfer;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.transfer.IInventoryWrapper;
import com.refinedmods.refinedstorage.container.transfer.InsertionResult;
import com.refinedmods.refinedstorage.container.transfer.InsertionResultType;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

class FluidFilterInventoryWrapper
implements IInventoryWrapper {
    private final FluidInventory filterInv;

    FluidFilterInventoryWrapper(FluidInventory filterInv) {
        this.filterInv = filterInv;
    }

    @Override
    public InsertionResult insert(ItemStack stack) {
        InsertionResult stop = new InsertionResult(InsertionResultType.STOP);
        FluidStack fluidInContainer = (FluidStack)StackUtils.getFluid(stack, true).getValue();
        if (fluidInContainer.isEmpty()) {
            return stop;
        }
        for (FluidStack fluid : this.filterInv.getFluids()) {
            if (!API.instance().getComparer().isEqual(fluidInContainer, fluid, 1)) continue;
            return stop;
        }
        for (int i = 0; i < this.filterInv.getSlots(); ++i) {
            if (!this.filterInv.getFluid(i).isEmpty()) continue;
            this.filterInv.setFluid(i, StackUtils.copy(fluidInContainer, 1000));
            return stop;
        }
        return stop;
    }
}

