/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.integration.jei.IngredientTracker;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferCraftingGridError;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferPatternGridError;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewRequestMessage;
import com.refinedmods.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.refinedmods.refinedstorage.network.grid.GridTransferMessage;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class GridRecipeTransferHandler
implements IRecipeTransferHandler<GridContainerMenu, Object> {
    public static final GridRecipeTransferHandler INSTANCE = new GridRecipeTransferHandler();
    private static final long TRANSFER_SCROLLBAR_DELAY_MS = 200L;
    private long lastTransferTimeMs;

    private GridRecipeTransferHandler() {
    }

    public Class<GridContainerMenu> getContainerClass() {
        return GridContainerMenu.class;
    }

    public Class<Object> getRecipeClass() {
        return Object.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(GridContainerMenu container, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!(container.getScreenInfoProvider() instanceof GridScreen)) {
            return null;
        }
        GridType type = container.getGrid().getGridType();
        if (type == GridType.CRAFTING) {
            return this.transferRecipeForCraftingGrid(container, recipe, recipeSlots, player, doTransfer);
        }
        if (type == GridType.PATTERN) {
            return this.transferRecipeForPatternGrid(container, recipe, recipeSlots, player, doTransfer);
        }
        return null;
    }

    private RecipeTransferCraftingGridError transferRecipeForCraftingGrid(GridContainerMenu container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean doTransfer) {
        IngredientTracker tracker = this.createTracker(container, recipeLayout, player, doTransfer);
        if (doTransfer) {
            if (tracker.hasMissingButAutocraftingAvailable() && Screen.m_96637_()) {
                tracker.createCraftingRequests().forEach((id, count) -> RS.NETWORK_HANDLER.sendToServer(new GridCraftingPreviewRequestMessage((UUID)id, (int)count, Screen.m_96638_(), false)));
            } else {
                this.moveItems(container, recipe, recipeLayout, tracker);
            }
        } else if (tracker.hasMissing()) {
            return new RecipeTransferCraftingGridError(tracker);
        }
        return null;
    }

    private IRecipeTransferError transferRecipeForPatternGrid(GridContainerMenu container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean doTransfer) {
        IngredientTracker tracker = this.createTracker(container, recipeLayout, player, doTransfer);
        if (doTransfer) {
            this.moveItems(container, recipe, recipeLayout, tracker);
        } else if (tracker.isAutocraftingAvailable()) {
            return new RecipeTransferPatternGridError(tracker);
        }
        return null;
    }

    private IngredientTracker createTracker(GridContainerMenu container, IRecipeSlotsView recipeLayout, Player player, boolean doTransfer) {
        CraftingContainer craftingMatrix;
        IngredientTracker tracker = new IngredientTracker(recipeLayout, doTransfer);
        Collection<IGridStack> gridStacks = ((GridScreen)container.getScreenInfoProvider()).getView().getAllStacks();
        if (container.getGrid().isGridActive()) {
            for (IGridStack gridStack : gridStacks) {
                if (!(gridStack instanceof ItemGridStack)) continue;
                tracker.addAvailableStack(((ItemGridStack)gridStack).getStack(), gridStack);
            }
        }
        for (int inventorySlot = 0; inventorySlot < player.m_150109_().m_6643_(); ++inventorySlot) {
            if (player.m_150109_().m_8020_(inventorySlot).m_41619_()) continue;
            tracker.addAvailableStack(player.m_150109_().m_8020_(inventorySlot), null);
        }
        if (container.getGrid().getGridType().equals((Object)GridType.CRAFTING) && (craftingMatrix = container.getGrid().getCraftingMatrix()) != null) {
            for (int matrixSlot = 0; matrixSlot < craftingMatrix.m_6643_(); ++matrixSlot) {
                if (craftingMatrix.m_8020_(matrixSlot).m_41619_()) continue;
                tracker.addAvailableStack(craftingMatrix.m_8020_(matrixSlot), null);
            }
        }
        return tracker;
    }

    public boolean hasTransferredRecently() {
        return System.currentTimeMillis() - this.lastTransferTimeMs <= 200L;
    }

    private void moveItems(GridContainerMenu gridContainer, Object recipe, IRecipeSlotsView recipeLayout, IngredientTracker tracker) {
        this.lastTransferTimeMs = System.currentTimeMillis();
        boolean isCraftingRecipe = false;
        if (recipe instanceof Recipe) {
            Recipe castRecipe = (Recipe)recipe;
            boolean bl = isCraftingRecipe = castRecipe.m_6671_() == RecipeType.f_44107_;
        }
        if (gridContainer.getGrid().getGridType() == GridType.PATTERN && !isCraftingRecipe) {
            this.moveForProcessing(recipeLayout, tracker);
        } else {
            this.move(recipeLayout);
        }
    }

    private void move(IRecipeSlotsView recipeSlotsView) {
        List<List<ItemStack>> inputs = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().map(view -> {
            List stacks = view.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).collect(Collectors.toCollection(ArrayList::new));
            Optional displayStack = view.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
            displayStack.ifPresent(stack -> {
                int index = stacks.indexOf(stack);
                if (index > -1) {
                    stacks.remove(index);
                    stacks.add(0, stack);
                }
            });
            return stacks;
        }).toList();
        RS.NETWORK_HANDLER.sendToServer(new GridTransferMessage(inputs));
    }

    private void moveForProcessing(IRecipeSlotsView recipeLayout, IngredientTracker tracker) {
        LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
        LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
        LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
        List inputSlots = recipeLayout.getSlotViews(RecipeIngredientRole.INPUT);
        for (IRecipeSlotView view : inputSlots) {
            this.handleItemIngredient(inputs, view, tracker);
            this.handleFluidIngredient(fluidInputs, view);
        }
        List outputSlots = recipeLayout.getSlotViews(RecipeIngredientRole.OUTPUT);
        for (IRecipeSlotView view : outputSlots) {
            this.handleItemIngredient(outputs, view, tracker);
            this.handleFluidIngredient(fluidOutputs, view);
        }
        RS.NETWORK_HANDLER.sendToServer(new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs));
    }

    private void handleFluidIngredient(List<FluidStack> list, IRecipeSlotView slotView) {
        if (slotView != null) {
            slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(list::add);
        }
    }

    private void handleItemIngredient(List<ItemStack> list, IRecipeSlotView slotView, IngredientTracker tracker) {
        if (slotView != null && slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).findAny().isPresent()) {
            ItemStack stack = tracker.findBestMatch(slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList());
            if (stack.m_41619_() && slotView.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).isPresent()) {
                stack = (ItemStack)slotView.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).get();
            }
            if (!stack.m_41619_()) {
                list.add(stack);
            }
        }
    }
}

