/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.craftingmonitor;

import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.ICraftingMonitor;
import com.refinedmods.refinedstorage.network.ClientProxy;
import com.refinedmods.refinedstorage.screen.CraftingMonitorScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingMonitorUpdateMessage {
    private static final Logger LOGGER = LogManager.getLogger(CraftingMonitorUpdateMessage.class);
    private ICraftingMonitor craftingMonitor;
    private List<IGridTab> tasks = new ArrayList<IGridTab>();

    public CraftingMonitorUpdateMessage(ICraftingMonitor craftingMonitor) {
        this.craftingMonitor = craftingMonitor;
    }

    public CraftingMonitorUpdateMessage(List<IGridTab> tasks) {
        this.tasks = tasks;
    }

    public static CraftingMonitorUpdateMessage decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<IGridTab> tasks = new ArrayList<IGridTab>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.m_130259_();
            ICraftingRequestInfo requested = null;
            try {
                requested = API.instance().createCraftingRequestInfo(buf.m_130260_());
            }
            catch (CraftingTaskReadException e) {
                LOGGER.error("Could not create crafting request info", (Throwable)e);
            }
            int qty = buf.readInt();
            long executionStarted = buf.readLong();
            int percentage = buf.readInt();
            ArrayList<ICraftingMonitorElement> elements = new ArrayList<ICraftingMonitorElement>();
            int elementCount = buf.readInt();
            for (int j = 0; j < elementCount; ++j) {
                Function<FriendlyByteBuf, ICraftingMonitorElement> factory = API.instance().getCraftingMonitorElementRegistry().get(buf.m_130281_());
                if (factory == null) continue;
                elements.add(factory.apply(buf));
            }
            tasks.add(new CraftingMonitorScreen.Task(id, requested, qty, executionStarted, percentage, elements));
        }
        return new CraftingMonitorUpdateMessage(tasks);
    }

    public static void encode(CraftingMonitorUpdateMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.craftingMonitor.getTasks().size());
        for (ICraftingTask task : message.craftingMonitor.getTasks()) {
            buf.m_130077_(task.getId());
            buf.m_130079_(task.getRequested().writeToNbt());
            buf.writeInt(task.getQuantity());
            buf.writeLong(task.getStartTime());
            buf.writeInt(task.getCompletionPercentage());
            List<ICraftingMonitorElement> elements = task.getCraftingMonitorElements();
            buf.writeInt(elements.size());
            for (ICraftingMonitorElement element : elements) {
                buf.m_130085_(element.getId());
                element.write(buf);
            }
        }
    }

    public static void handle(CraftingMonitorUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientProxy.onReceivedCraftingMonitorUpdateMessage(message));
        ctx.get().setPacketHandled(true);
    }

    public List<IGridTab> getTasks() {
        return this.tasks;
    }
}

