/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.sync;

import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class BlockEntitySynchronizationParameterMessage {
    private final BlockEntity blockEntity;
    private final BlockEntitySynchronizationParameter parameter;
    private final boolean initial;

    public BlockEntitySynchronizationParameterMessage(BlockEntity blockEntity, BlockEntitySynchronizationParameter parameter, boolean initial) {
        this.blockEntity = blockEntity;
        this.parameter = parameter;
        this.initial = initial;
    }

    public static BlockEntitySynchronizationParameterMessage decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean initial = buf.readBoolean();
        BlockEntitySynchronizationParameter parameter = BlockEntitySynchronizationManager.getParameter(id);
        if (parameter != null) {
            try {
                parameter.setValue(initial, parameter.getSerializer().m_6709_(buf));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new BlockEntitySynchronizationParameterMessage(null, null, initial);
    }

    public static void encode(BlockEntitySynchronizationParameterMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.parameter.getId());
        buf.writeBoolean(message.initial);
        message.parameter.getSerializer().m_6856_(buf, message.parameter.getValueProducer().apply(message.blockEntity));
    }

    public static void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
    }
}

