/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.api.control.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SecurityHelper {
    public static final GameProfile DEFAULT_GAME_PROFILE = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    private static UUID cachedId;

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uuid) {
        return uuid == null || uuid.version() == 4 && uuid.variant() == 0;
    }

    public static boolean isDefaultProfile(GameProfile profile) {
        return DEFAULT_GAME_PROFILE.equals((Object)profile);
    }

    public static UUID getID(Entity entity) {
        if (entity == null) {
            return DEFAULT_GAME_PROFILE.getId();
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                return player.m_36316_().getId();
            }
            return SecurityHelper.getClientID(player);
        }
        return entity.m_142081_();
    }

    private static UUID getClientID(Player player) {
        if (player != Minecraft.m_91087_().f_91074_) {
            return player.m_36316_().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.m_91087_().f_91074_.m_36316_().getId();
        }
        return cachedId;
    }

    public static boolean hasSecurity(BlockEntity tile) {
        if (tile instanceof ISecurable) {
            return !SecurityHelper.isDefaultProfile(((ISecurable)tile).getOwner());
        }
        return false;
    }

    public static String getOwnerName(BlockEntity tile) {
        if (SecurityHelper.hasSecurity(tile)) {
            return ((ISecurable)tile).getOwnerName();
        }
        return DEFAULT_GAME_PROFILE.getName();
    }

    public static void createSecurityTag(ItemStack stack) {
        stack.m_41698_("Security");
    }

    public static boolean isItemClaimable(ItemStack stack) {
        return SecurityHelper.hasSecurity(stack) && SecurityHelper.getOwner(stack) == DEFAULT_GAME_PROFILE;
    }

    public static boolean attemptClaimItem(ItemStack stack, Player player) {
        if (SecurityHelper.isItemClaimable(stack)) {
            SecurityHelper.setOwner(stack, player.m_36316_());
            SecurityHelper.setAccess(stack, ISecurable.AccessMode.PUBLIC);
            return true;
        }
        return false;
    }

    public static CompoundTag getSecurityTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            return nbt.m_128441_("Security") ? nbt.m_128469_("Security") : null;
        }
        return stack.m_41737_("Security");
    }

    public static boolean hasSecurity(ItemStack stack) {
        return SecurityHelper.getSecurityTag(stack) != null;
    }

    public static void setAccess(ItemStack stack, ISecurable.AccessMode access) {
        CompoundTag secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            secureTag.m_128344_("SecAccess", (byte)access.ordinal());
        }
    }

    public static void setOwner(ItemStack stack, GameProfile profile) {
        CompoundTag secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            secureTag.m_128359_("SecUUID", profile.getId().toString());
            secureTag.m_128359_("SecName", profile.getName());
        }
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        CompoundTag secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null && secureTag.m_128441_("SecAccess")) {
            return ISecurable.AccessMode.VALUES[secureTag.m_128445_("SecAccess")];
        }
        return ISecurable.AccessMode.PUBLIC;
    }

    public static GameProfile getOwner(ItemStack stack) {
        CompoundTag secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            String uuid = secureTag.m_128461_("SecUUID");
            String name = secureTag.m_128461_("SecName");
            if (!Strings.isNullOrEmpty((String)uuid)) {
                return new GameProfile(UUID.fromString(uuid), name);
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                return new GameProfile(OldUsersConverter.m_11083_((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (String)name), name);
            }
        }
        return DEFAULT_GAME_PROFILE;
    }

    public static String getOwnerName(ItemStack stack) {
        String name;
        CompoundTag secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null && !Strings.isNullOrEmpty((String)(name = secureTag.m_128461_("SecName")))) {
            return name;
        }
        return StringHelper.localize("info.cofh.another_player");
    }
}

