/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part;

import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public abstract class AbstractMultiblockEntity<Controller extends AbstractCuboidMultiblockController<Controller>>
extends AbstractCuboidMultiblockPart<Controller> {
    private IModelData _clientModelData;

    public AbstractMultiblockEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected abstract IModelData getUpdatedModelData();

    @Override
    public void onPostMachineAssembled(Controller controller) {
        super.onPostMachineAssembled(controller);
        this.updateClientRenderState();
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.updateClientRenderState();
    }

    @Override
    public void markForRenderUpdate() {
        this.updateClientRenderState();
        super.markForRenderUpdate();
    }

    @Nonnull
    public IModelData getModelData() {
        if (null == this._clientModelData) {
            this._clientModelData = this.getUpdatedModelData();
        }
        return this._clientModelData;
    }

    private void updateClientRenderState() {
        this.callOnLogicalClient(() -> {
            this._clientModelData = null;
            this.requestModelDataUpdate();
            this.notifyBlockUpdate();
        });
    }
}

