/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import com.google.common.base.Strings;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTBuilder {
    private final CompoundTag _root = new CompoundTag();

    public CompoundTag build() {
        return this._root;
    }

    public NBTBuilder merge(NBTBuilder builder) {
        this._root.m_128391_(builder.build());
        return this;
    }

    public NBTBuilder merge(CompoundTag compound) {
        this._root.m_128391_(compound);
        return this;
    }

    public NBTBuilder addEntity(String name, ISyncableEntity entity, ISyncableEntity.SyncReason syncReason) {
        NBTBuilder.validateName(name);
        this._root.m_128365_(name, (Tag)entity.syncDataTo(new CompoundTag(), syncReason));
        return this;
    }

    public NBTBuilder addCompound(String name, Consumer<NBTBuilder> builder) {
        NBTBuilder.validateName(name);
        NBTBuilder b = new NBTBuilder();
        builder.accept(b);
        this._root.m_128365_(name, (Tag)b.build());
        return this;
    }

    public NBTBuilder addByte(String name, byte value) {
        NBTBuilder.validateName(name);
        this._root.m_128344_(name, value);
        return this;
    }

    public NBTBuilder addShort(String name, short value) {
        NBTBuilder.validateName(name);
        this._root.m_128376_(name, value);
        return this;
    }

    public NBTBuilder addInteger(String name, int value) {
        NBTBuilder.validateName(name);
        this._root.m_128405_(name, value);
        return this;
    }

    public NBTBuilder addLong(String name, long value) {
        NBTBuilder.validateName(name);
        this._root.m_128356_(name, value);
        return this;
    }

    public NBTBuilder addFloat(String name, float value) {
        NBTBuilder.validateName(name);
        this._root.m_128350_(name, value);
        return this;
    }

    public NBTBuilder addDouble(String name, double value) {
        NBTBuilder.validateName(name);
        this._root.m_128347_(name, value);
        return this;
    }

    public NBTBuilder addBoolean(String name, boolean value) {
        NBTBuilder.validateName(name);
        this._root.m_128379_(name, value);
        return this;
    }

    public NBTBuilder addString(String name, String value) {
        NBTBuilder.validateName(name);
        this._root.m_128359_(name, value);
        return this;
    }

    public NBTBuilder addByteArray(String name, byte[] value) {
        NBTBuilder.validateName(name);
        this._root.m_128382_(name, value);
        return this;
    }

    public NBTBuilder addIntArray(String name, int[] value) {
        NBTBuilder.validateName(name);
        this._root.m_128385_(name, value);
        return this;
    }

    public NBTBuilder addIntArray(String name, List<Integer> value) {
        NBTBuilder.validateName(name);
        this._root.m_128408_(name, value);
        return this;
    }

    public NBTBuilder addLongArray(String name, long[] value) {
        NBTBuilder.validateName(name);
        this._root.m_128388_(name, value);
        return this;
    }

    public NBTBuilder addLongArray(String name, List<Long> value) {
        NBTBuilder.validateName(name);
        this._root.m_128428_(name, value);
        return this;
    }

    public NBTBuilder addUniqueId(String name, UUID value) {
        NBTBuilder.validateName(name);
        this._root.m_128362_(name, value);
        return this;
    }

    private static void validateName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid tag name");
        }
    }
}

