/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.BitSet;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class InventoryModifier
extends Modifier
implements ToolInventoryCapability.InventoryModifierHook {
    protected static final BiFunction<CompoundTag, String, ListTag> GET_COMPOUND_LIST = (nbt, name) -> nbt.m_128437_(name, 10);
    private static final ValidatedResult HAS_ITEMS = ValidatedResult.failure(TConstruct.makeTranslationKey("modifier", "inventory_cannot_remove"), new Object[0]);
    protected static final String TAG_SLOT = "Slot";
    @Nullable
    private final ResourceLocation inventoryKey;
    protected final int slotsPerLevel;

    public InventoryModifier(int slotsPerLevel) {
        this(null, slotsPerLevel);
    }

    protected ResourceLocation getInventoryKey() {
        return this.inventoryKey == null ? this.getId() : this.inventoryKey;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ToolInventoryCapability.addSlots(volatileData, this.getSlots(context, level));
    }

    protected ValidatedResult validateForMaxSlots(IToolStackView tool, int maxSlots) {
        ListTag listNBT;
        ResourceLocation key;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(key = this.getInventoryKey(), 9) && !(listNBT = persistentData.get(key, GET_COMPOUND_LIST)).isEmpty()) {
            int i;
            if (maxSlots == 0) {
                return HAS_ITEMS;
            }
            BitSet freeSlots = new BitSet(maxSlots);
            freeSlots.set(0, maxSlots - 1, true);
            for (i = 0; i < listNBT.size(); ++i) {
                freeSlots.set(listNBT.m_128728_(i).m_128451_(TAG_SLOT), false);
            }
            for (i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.m_128728_(i);
                if (compoundNBT.m_128451_(TAG_SLOT) < maxSlots) continue;
                int free = freeSlots.stream().findFirst().orElse(-1);
                if (free == -1) {
                    return HAS_ITEMS;
                }
                freeSlots.set(free, false);
                compoundNBT.m_128405_(TAG_SLOT, free);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        return this.validateForMaxSlots(tool, level == 0 ? 0 : this.getSlots((IToolContext)tool, level));
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.getInventoryKey());
    }

    @Override
    public ItemStack getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
        ModDataNBT modData = tool.getPersistentData();
        ResourceLocation key = this.getInventoryKey();
        if (slot < this.getSlots(tool, modifier) && modData.contains(key, 9)) {
            ListTag list = tool.getPersistentData().get(key, GET_COMPOUND_LIST);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                if (compound.m_128451_(TAG_SLOT) != slot) continue;
                return ItemStack.m_41712_((CompoundTag)compound);
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
        if (slot < this.getSlots(tool, modifier)) {
            ListTag list;
            ResourceLocation key;
            ModDataNBT modData = tool.getPersistentData();
            if (modData.contains(key = this.getInventoryKey(), 9)) {
                list = modData.get(key, GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag compound = list.m_128728_(i);
                    if (compound.m_128451_(TAG_SLOT) != slot) continue;
                    if (stack.m_41619_()) {
                        list.remove(i);
                    } else {
                        compound.m_128431_().clear();
                        stack.m_41739_(compound);
                        compound.m_128405_(TAG_SLOT, slot);
                    }
                    return;
                }
            } else {
                if (stack.m_41619_()) {
                    return;
                }
                list = new ListTag();
                modData.put(key, (Tag)list);
            }
            if (!stack.m_41619_()) {
                list.add((Object)InventoryModifier.write(stack, slot));
            }
        }
    }

    public int getSlots(IToolContext tool, int level) {
        return level * this.slotsPerLevel;
    }

    @Override
    public final int getSlots(IToolStackView tool, ModifierEntry modifier) {
        return this.getSlots((IToolContext)tool, modifier.getLevel());
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ToolInventoryCapability.HOOK);
    }

    protected static CompoundTag write(ItemStack stack, int slot) {
        CompoundTag compound = new CompoundTag();
        stack.m_41739_(compound);
        compound.m_128405_(TAG_SLOT, slot);
        return compound;
    }

    public InventoryModifier(@Nullable ResourceLocation inventoryKey, int slotsPerLevel) {
        this.inventoryKey = inventoryKey;
        this.slotsPerLevel = slotsPerLevel;
    }
}

