/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.ConditionSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.UpdateSpillingFluidsPacket;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class SpillingFluidManager
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(SpillingFluidManager.class);
    public static final String FOLDER = "tinkering/spilling";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ICondition.class, (Object)ConditionSerializer.INSTANCE).registerTypeHierarchyAdapter(ISpillingEffect.class, ISpillingEffect.LOADER).registerTypeAdapter(FluidIngredient.class, (Object)FluidIngredient.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    public static final SpillingFluidManager INSTANCE = new SpillingFluidManager();
    private List<SpillingFluid> fluids = Collections.emptyList();
    private final Map<Fluid, SpillingFluid> cache = new ConcurrentHashMap<Fluid, SpillingFluid>();
    private static final SpillingFluid EMPTY = new SpillingFluid(FluidIngredient.EMPTY, Collections.emptyList());
    private ICondition.IContext conditionContext = ICondition.IContext.EMPTY;

    private SpillingFluidManager() {
        super(GSON, FOLDER);
    }

    @Deprecated
    public void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, this::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, OnDatapackSyncEvent.class, e -> JsonUtils.syncPackets(e, new UpdateSpillingFluidsPacket(this.fluids)));
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
        this.conditionContext = event.getConditionContext();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        this.fluids = splashList.entrySet().stream().map(entry -> this.loadFluid((ResourceLocation)entry.getKey(), (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).toList();
        this.cache.clear();
        log.info("Loaded {} spilling fluids in {} ms", (Object)this.fluids.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    @Nullable
    private SpillingFluid loadFluid(ResourceLocation key, JsonElement element) {
        try {
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"fluid");
            if (json.has("condition") && !CraftingHelper.getCondition((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"condition")).test(this.conditionContext)) {
                return null;
            }
            FluidIngredient ingredient = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            List effects = JsonHelper.parseList((JsonObject)json, (String)"effects", obj -> (ISpillingEffect)GSON.fromJson((JsonElement)obj, ISpillingEffect.class));
            return new SpillingFluid(ingredient, effects);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load modifier {}", (Object)key, (Object)e);
            return null;
        }
    }

    void updateFromServer(List<SpillingFluid> fluids) {
        this.fluids = fluids;
        this.cache.clear();
    }

    private SpillingFluid findUncached(Fluid fluid) {
        for (SpillingFluid recipe : this.fluids) {
            if (!recipe.matches(fluid)) continue;
            return recipe;
        }
        return EMPTY;
    }

    public boolean contains(Fluid fluid) {
        return this.find(fluid).hasEffects();
    }

    public SpillingFluid find(Fluid fluid) {
        return this.cache.computeIfAbsent(fluid, this::findUncached);
    }
}

