/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;

public final class DisplayCastingRecipe
implements IDisplayableCastingRecipe {
    private final RecipeType<?> type;
    private final List<ItemStack> castItems;
    private final List<FluidStack> fluids;
    private final ItemStack output;
    private final int coolingTime;
    private final boolean consumed;

    @Override
    public boolean hasCast() {
        return !this.castItems.isEmpty();
    }

    public DisplayCastingRecipe(RecipeType<?> type, List<ItemStack> castItems, List<FluidStack> fluids, ItemStack output, int coolingTime, boolean consumed) {
        this.type = type;
        this.castItems = castItems;
        this.fluids = fluids;
        this.output = output;
        this.coolingTime = coolingTime;
        this.consumed = consumed;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    @Override
    public List<ItemStack> getCastItems() {
        return this.castItems;
    }

    @Override
    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getCoolingTime() {
        return this.coolingTime;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayCastingRecipe)) {
            return false;
        }
        DisplayCastingRecipe other = (DisplayCastingRecipe)o;
        if (this.getCoolingTime() != other.getCoolingTime()) {
            return false;
        }
        if (this.isConsumed() != other.isConsumed()) {
            return false;
        }
        RecipeType<?> this$type = this.getType();
        RecipeType<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<ItemStack> this$castItems = this.getCastItems();
        List<ItemStack> other$castItems = other.getCastItems();
        if (this$castItems == null ? other$castItems != null : !((Object)this$castItems).equals(other$castItems)) {
            return false;
        }
        List<FluidStack> this$fluids = this.getFluids();
        List<FluidStack> other$fluids = other.getFluids();
        if (this$fluids == null ? other$fluids != null : !((Object)this$fluids).equals(other$fluids)) {
            return false;
        }
        ItemStack this$output = this.getOutput();
        ItemStack other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !this$output.equals(other$output));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCoolingTime();
        result = result * 59 + (this.isConsumed() ? 79 : 97);
        RecipeType<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<ItemStack> $castItems = this.getCastItems();
        result = result * 59 + ($castItems == null ? 43 : ((Object)$castItems).hashCode());
        List<FluidStack> $fluids = this.getFluids();
        result = result * 59 + ($fluids == null ? 43 : ((Object)$fluids).hashCode());
        ItemStack $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        return result;
    }

    public String toString() {
        return "DisplayCastingRecipe(type=" + this.getType() + ", castItems=" + this.getCastItems() + ", fluids=" + this.getFluids() + ", output=" + this.getOutput() + ", coolingTime=" + this.getCoolingTime() + ", consumed=" + this.isConsumed() + ")";
    }
}

