/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class CompositeCastingRecipe
extends MaterialCastingRecipe {
    public CompositeCastingRecipe(RecipeType<?> type, ResourceLocation id, String group, IMaterialItem result, int itemCost) {
        super(type, id, group, Ingredient.m_43929_((ItemLike[])new ItemLike[]{result}), itemCost, result, true, false);
    }

    @Override
    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingContainer inv) {
        return MaterialCastingLookup.getCompositeFluid(inv);
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            RecipeType<?> type = this.m_6671_();
            this.multiRecipes = MaterialCastingLookup.getAllCompositeFluids().stream().filter(recipe -> {
                MaterialVariant output = recipe.getOutput();
                MaterialVariant input = recipe.getInput();
                return !output.isUnknown() && input != null && !input.isUnknown() && !output.get().isHidden() && !input.get().isHidden() && this.result.canUseMaterial(output.getId()) && this.result.canUseMaterial(input.getId());
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                return new DisplayCastingRecipe(type, Collections.singletonList(this.result.withMaterial(Objects.requireNonNull(recipe.getInput()).getVariant())), fluids, this.result.withMaterial(recipe.getOutput().getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.consumed);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends CompositeCastingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            IMaterialItem result = (IMaterialItem)RecipeHelper.deserializeItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (String)"result", IMaterialItem.class);
            int itemCost = GsonHelper.m_13927_((JsonObject)json, (String)"item_cost");
            return this.factory.create(id, group, result, itemCost);
        }

        @Nullable
        protected T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            IMaterialItem result = (IMaterialItem)RecipeHelper.readItem((FriendlyByteBuf)buffer, IMaterialItem.class);
            int itemCost = buffer.m_130242_();
            return this.factory.create(id, group, result, itemCost);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((CompositeCastingRecipe)recipe).group);
            RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)((CompositeCastingRecipe)recipe).result);
            buffer.m_130130_(((CompositeCastingRecipe)recipe).itemCost);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends CompositeCastingRecipe> {
        public T create(ResourceLocation var1, String var2, IMaterialItem var3, int var4);
    }

    public static class Table
    extends CompositeCastingRecipe {
        public Table(ResourceLocation id, String group, IMaterialItem result, int itemCost) {
            super((RecipeType)TinkerRecipeTypes.CASTING_TABLE.get(), id, group, result, itemCost);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.tableCompositeSerializer.get();
        }
    }

    public static class Basin
    extends CompositeCastingRecipe {
        public Basin(ResourceLocation id, String group, IMaterialItem result, int itemCost) {
            super((RecipeType)TinkerRecipeTypes.CASTING_BASIN.get(), id, group, result, itemCost);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.basinCompositeSerializer.get();
        }
    }
}

