/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.PartBuilderContainerWrapper;

public interface IPartBuilderRecipe
extends ICommonRecipe<IPartBuilderContainer> {
    public Pattern getPattern();

    default public Stream<Pattern> getPatterns(IPartBuilderContainer inv) {
        return Stream.of(this.getPattern());
    }

    public int getCost();

    public boolean partialMatch(IPartBuilderContainer var1);

    default public int getItemsUsed(IPartBuilderContainer inv) {
        return Optional.ofNullable(inv.getMaterial()).map(mat -> mat.getItemsUsed(this.getCost())).orElse(1);
    }

    default public ItemStack assemble(IPartBuilderContainer inv, Pattern pattern) {
        return this.m_5874_((Container)inv);
    }

    default public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.PART_BUILDER.get();
    }

    default public ItemStack m_8042_() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    @Deprecated
    default public ItemStack getLeftover(PartBuilderContainerWrapper inventoryWrapper) {
        int value;
        IMaterialValue recipe = inventoryWrapper.getMaterial();
        if (recipe != null && (value = recipe.getValue()) > 1) {
            int remainder = (value - this.getCost()) % value;
            if (remainder < 0) {
                remainder += value;
            }
            if (remainder != 0) {
                ItemStack leftover = recipe.getLeftover();
                leftover.m_41764_(leftover.m_41613_() * remainder);
                return leftover;
            }
        }
        return ItemStack.f_41583_;
    }

    default public ItemStack getLeftover(PartBuilderContainerWrapper inventoryWrapper, Pattern pattern) {
        return this.getLeftover(inventoryWrapper);
    }

    @Nullable
    default public Component getTitle() {
        return null;
    }

    default public List<Component> getText(IPartBuilderContainer inv) {
        return Collections.emptyList();
    }
}

