/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.library.tools.SlotType;

public class DefinitionModifierSlots {
    protected static final DefinitionModifierSlots EMPTY = new DefinitionModifierSlots(Collections.emptyMap());
    public static Serializer SERIALIZER = new Serializer();
    private final Map<SlotType, Integer> slots;

    public int getSlots(SlotType slotType) {
        return this.slots.getOrDefault(slotType, 0);
    }

    public Set<SlotType> containedTypes() {
        return this.slots.keySet();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.slots.size());
        for (Map.Entry<SlotType, Integer> entry : this.slots.entrySet()) {
            buffer.m_130070_(entry.getKey().getName());
            buffer.m_130130_(entry.getValue().intValue());
        }
    }

    public static DefinitionModifierSlots read(FriendlyByteBuf buffer) {
        Builder builder = DefinitionModifierSlots.builder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            SlotType slotType = SlotType.getOrCreate(buffer.m_130136_(Short.MAX_VALUE));
            builder.setSlots(slotType, buffer.m_130242_());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected DefinitionModifierSlots(Map<SlotType, Integer> slots) {
        this.slots = slots;
    }

    public static class Builder {
        private final ImmutableMap.Builder<SlotType, Integer> builder = ImmutableMap.builder();

        protected Builder() {
        }

        public Builder setSlots(SlotType slotType, int count) {
            this.builder.put((Object)slotType, (Object)count);
            return this;
        }

        public DefinitionModifierSlots build() {
            return new DefinitionModifierSlots((Map<SlotType, Integer>)this.builder.build());
        }
    }

    protected static class Serializer
    implements JsonDeserializer<DefinitionModifierSlots>,
    JsonSerializer<DefinitionModifierSlots> {
        protected Serializer() {
        }

        public DefinitionModifierSlots deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"stats");
            Builder builder = DefinitionModifierSlots.builder();
            for (Map.Entry entry : object.entrySet()) {
                int value = GsonHelper.m_13897_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                SlotType slotType = SlotType.getOrCreate((String)entry.getKey());
                builder.setSlots(slotType, value);
            }
            return builder.build();
        }

        public JsonElement serialize(DefinitionModifierSlots stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<SlotType, Integer> entry : stats.slots.entrySet()) {
                json.addProperty(entry.getKey().getName(), (Number)entry.getValue());
            }
            return json;
        }
    }
}

