/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerTools;

public class SeveringCategory
implements IRecipeCategory<SeveringRecipe> {
    public static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "severing.title");
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final IDrawable background;
    private final IDrawable icon;

    public SeveringCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 78, 100, 38);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((ModifiableItem)TinkerTools.cleaver.get()).getRenderTool());
    }

    public ResourceLocation getUid() {
        return TConstructJEIConstants.SEVERING.getUid();
    }

    public Class<? extends SeveringRecipe> getRecipeClass() {
        return SeveringRecipe.class;
    }

    public RecipeType<SeveringRecipe> getRecipeType() {
        return TConstructJEIConstants.SEVERING;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SeveringRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).setCustomRenderer(TConstructJEIConstants.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredients(TConstructJEIConstants.ENTITY_TYPE, EntityIngredientHelper.applyFocus(RecipeIngredientRole.INPUT, recipe.getEntityInputs(), focuses));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getItemInputs());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 11).addItemStack(recipe.getOutput());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

