/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;

public class GuiTankModule {
    private static final Component NO_CAPACITY = new TranslatableComponent(Mantle.makeDescriptionId((String)"gui", (String)"fluid.millibucket"), new Object[]{0}).m_130940_(ChatFormatting.GRAY);
    private static final int TANK_INDEX = 0;
    private final AbstractContainerScreen<?> screen;
    private final IFluidHandler tank;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final BiConsumer<Integer, List<Component>> formatter;

    public GuiTankModule(AbstractContainerScreen<?> screen, IFluidHandler tank, int x, int y, int width, int height, ResourceLocation tooltipId) {
        this.screen = screen;
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.formatter = (amount, tooltip) -> FluidTooltipHandler.appendNamedList((ResourceLocation)tooltipId, (int)amount, (List)tooltip);
    }

    private boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    private int getFluidHeight() {
        int capacity = this.tank.getTankCapacity(0);
        if (capacity == 0) {
            return this.height;
        }
        return this.height * this.tank.getFluidInTank(0).getAmount() / capacity;
    }

    public void draw(PoseStack matrices) {
        GuiUtil.renderFluidTank(matrices, this.screen, this.tank.getFluidInTank(0), this.tank.getTankCapacity(0), this.x, this.y, this.width, this.height, 100);
    }

    public void highlightHoveredFluid(PoseStack matrices, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            int fluidHeight = this.getFluidHeight();
            int middle = this.y + this.height - fluidHeight;
            if (checkY > middle) {
                GuiUtil.renderHighlight(matrices, this.x, middle, this.width, fluidHeight);
            } else {
                GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height - fluidHeight);
            }
        }
    }

    public void renderTooltip(PoseStack matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.f_97735_;
        int checkY = mouseY - this.screen.f_97736_;
        if (this.isHovered(checkX, checkY)) {
            List<Component> tooltip;
            FluidStack fluid = this.tank.getFluidInTank(0);
            int amount = fluid.getAmount();
            int capacity = this.tank.getTankCapacity(0);
            if (capacity > 0 && checkY > this.y + this.height - this.getFluidHeight()) {
                tooltip = FluidTooltipHandler.getFluidTooltip((FluidStack)fluid);
            } else {
                BiConsumer<Integer, List<Component>> formatter = Screen.m_96638_() ? FluidTooltipHandler.BUCKET_FORMATTER : this.formatter;
                tooltip = new ArrayList<Component>();
                tooltip.add(GuiSmelteryTank.TOOLTIP_CAPACITY);
                if (capacity == 0) {
                    tooltip.add(NO_CAPACITY);
                } else {
                    formatter.accept(capacity, tooltip);
                    if (capacity != amount) {
                        tooltip.add(GuiSmelteryTank.TOOLTIP_AVAILABLE);
                        formatter.accept(capacity - amount, tooltip);
                    }
                    FluidTooltipHandler.appendShift(tooltip);
                }
            }
            this.screen.m_96597_(matrices, tooltip, mouseX, mouseY);
        }
    }

    @Nullable
    public FluidStack getIngreientUnderMouse(int checkX, int checkY) {
        if (this.isHovered(checkX, checkY) && checkY > this.y + this.height - this.getFluidHeight()) {
            return this.tank.getFluidInTank(0);
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

