/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.tools.stats.BowstringMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;

public class RangedToolStatsBuilder
extends ToolStatsBuilder {
    private final List<LimbMaterialStats> limbs;
    private final List<GripMaterialStats> grips;
    private final List<BowstringMaterialStats> strings;

    @VisibleForTesting
    public RangedToolStatsBuilder(ToolDefinitionData toolData, List<LimbMaterialStats> limbs, List<GripMaterialStats> grips, List<BowstringMaterialStats> strings) {
        super(toolData);
        this.limbs = limbs;
        this.grips = grips;
        this.strings = strings;
    }

    public static ToolStatsBuilder from(ToolDefinition toolDefinition, MaterialNBT materials) {
        ToolDefinitionData data = toolDefinition.getData();
        List<PartRequirement> requiredComponents = data.getParts();
        if (materials.size() != requiredComponents.size()) {
            return ToolStatsBuilder.noParts(toolDefinition);
        }
        return new RangedToolStatsBuilder(data, RangedToolStatsBuilder.listOfCompatibleWith(LimbMaterialStats.ID, materials, requiredComponents), RangedToolStatsBuilder.listOfCompatibleWith(GripMaterialStats.ID, materials, requiredComponents), RangedToolStatsBuilder.listOfCompatibleWith(BowstringMaterialStats.ID, materials, requiredComponents));
    }

    @Override
    protected void setStats(StatsNBT.Builder builder) {
        builder.set(ToolStats.DURABILITY, Float.valueOf(this.buildDurability()));
        builder.set(ToolStats.DRAW_SPEED, Float.valueOf(this.buildDrawSpeed()));
        builder.set(ToolStats.VELOCITY, Float.valueOf(this.buildVelocity()));
        builder.set(ToolStats.ACCURACY, Float.valueOf(this.buildAccuracy()));
        builder.set(ToolStats.ATTACK_DAMAGE, Float.valueOf(this.buildAttackDamage()));
    }

    @Override
    protected boolean handles(IToolStat<?> stat) {
        return stat == ToolStats.DURABILITY || stat == ToolStats.ATTACK_DAMAGE || stat == ToolStats.DRAW_SPEED || stat == ToolStats.VELOCITY || stat == ToolStats.ACCURACY;
    }

    public float buildDurability() {
        double averageHeadDurability = RangedToolStatsBuilder.getTotalValue(this.limbs, LimbMaterialStats::getDurability) + (double)this.getStatOrDefault(ToolStats.DURABILITY, Float.valueOf(0.0f)).floatValue();
        double averageHandleModifier = RangedToolStatsBuilder.getAverageValue(this.grips, GripMaterialStats::getDurability, 1.0);
        return Math.max(1, (int)(averageHeadDurability * averageHandleModifier));
    }

    public float buildDrawSpeed() {
        return (float)Math.max(0.0, (double)this.getStatOrDefault(ToolStats.DRAW_SPEED, Float.valueOf(1.0f)).floatValue() + RangedToolStatsBuilder.getTotalValue(this.limbs, LimbMaterialStats::getDrawSpeed));
    }

    public float buildVelocity() {
        return (float)Math.max(0.0, (double)this.getStatOrDefault(ToolStats.VELOCITY, Float.valueOf(1.0f)).floatValue() + RangedToolStatsBuilder.getTotalValue(this.limbs, LimbMaterialStats::getVelocity));
    }

    public float buildAccuracy() {
        return (float)Math.max(0.0, (double)this.getStatOrDefault(ToolStats.ACCURACY, Float.valueOf(0.75f)).floatValue() + RangedToolStatsBuilder.getTotalValue(this.limbs, LimbMaterialStats::getAccuracy) + RangedToolStatsBuilder.getTotalValue(this.grips, GripMaterialStats::getAccuracy));
    }

    public float buildAttackDamage() {
        return (float)Math.max(0.0, (double)this.getStatOrDefault(ToolStats.ATTACK_DAMAGE, Float.valueOf(0.0f)).floatValue() + RangedToolStatsBuilder.getAverageValue(this.grips, GripMaterialStats::getMeleeAttack));
    }

    protected List<LimbMaterialStats> getLimbs() {
        return this.limbs;
    }

    protected List<GripMaterialStats> getGrips() {
        return this.grips;
    }

    protected List<BowstringMaterialStats> getStrings() {
        return this.strings;
    }
}

