/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.ranged;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.dynamic.InventoryMenuModifier;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TrickQuiverModifier
extends InventoryMenuModifier
implements BowAmmoModifierHook {
    private static final ResourceLocation INVENTORY_KEY = TConstruct.getResource("trick_quiver");
    private static final ResourceLocation SELECTED_SLOT = TConstruct.getResource("trick_quiver_selected");
    private static final Pattern TRICK_ARROW = new Pattern(TConstruct.getResource("tipped_arrow"));
    private static final Component DISABLED = TConstruct.makeTranslation("modifier", "trick_quiver.disabled");
    private static final String EMPTY = TConstruct.makeTranslationKey("modifier", "trick_quiver.empty");
    private static final String SELECTED = TConstruct.makeTranslationKey("modifier", "trick_quiver.selected");

    public TrickQuiverModifier() {
        super(INVENTORY_KEY, 3);
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.BOW_AMMO);
    }

    @Override
    public int getSlots(IToolContext tool, int level) {
        return 3;
    }

    @Override
    public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
        return modifier.getLevel() == 1 ? 32 : 64;
    }

    @Override
    public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
        Item item = stack.m_41720_();
        return item == Items.f_42688_ && tool.hasTag(TinkerTags.Items.CROSSBOWS) || stack.m_41720_() instanceof ArrowItem;
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
        return hasStack ? null : TRICK_ARROW;
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        return this.getStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT));
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ammo.m_41774_(needed);
        this.setStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT), ammo);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!player.m_6047_()) {
            if (!player.f_19853_.f_46443_) {
                ModDataNBT data = tool.getPersistentData();
                int totalSlots = this.getSlots((IToolContext)tool, modifier.getLevel());
                int newSelected = (data.getInt(SELECTED_SLOT) + 1) % (totalSlots + 1);
                data.putInt(SELECTED_SLOT, newSelected);
                if (newSelected == totalSlots) {
                    player.m_5661_(DISABLED, true);
                } else {
                    ItemStack selectedStack = this.getStack(tool, modifier, newSelected);
                    if (selectedStack.m_41619_()) {
                        player.m_5661_((Component)new TranslatableComponent(EMPTY, new Object[]{newSelected + 1}), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent(SELECTED, new Object[]{selectedStack.m_41786_(), newSelected + 1}), true);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onToolUse(tool, modifier, player, hand, source);
    }
}

