/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.data.sync;

import com.mrcrayfish.framework.api.data.sync.IDataSerializer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class Serializers {
    public static final IDataSerializer<Boolean> BOOLEAN = new IDataSerializer<Boolean>(){

        @Override
        public void write(FriendlyByteBuf buf, Boolean value) {
            buf.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean read(FriendlyByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public Tag write(Boolean value) {
            return ByteTag.m_128273_((boolean)value);
        }

        @Override
        public Boolean read(Tag tag) {
            return ((ByteTag)tag).m_7063_() != 0;
        }
    };
    public static final IDataSerializer<Byte> BYTE = new IDataSerializer<Byte>(){

        @Override
        public void write(FriendlyByteBuf buf, Byte value) {
            buf.writeByte((int)value.byteValue());
        }

        @Override
        public Byte read(FriendlyByteBuf buf) {
            return buf.readByte();
        }

        @Override
        public Tag write(Byte value) {
            return ByteTag.m_128266_((byte)value);
        }

        @Override
        public Byte read(Tag tag) {
            return ((ByteTag)tag).m_7063_();
        }
    };
    public static final IDataSerializer<Short> SHORT = new IDataSerializer<Short>(){

        @Override
        public void write(FriendlyByteBuf buf, Short value) {
            buf.writeShort((int)value.shortValue());
        }

        @Override
        public Short read(FriendlyByteBuf buf) {
            return buf.readShort();
        }

        @Override
        public Tag write(Short value) {
            return ShortTag.m_129258_((short)value);
        }

        @Override
        public Short read(Tag tag) {
            return ((ShortTag)tag).m_7053_();
        }
    };
    public static final IDataSerializer<Integer> INTEGER = new IDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.m_130130_(value.intValue());
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.m_130242_();
        }

        @Override
        public Tag write(Integer value) {
            return IntTag.m_128679_((int)value);
        }

        @Override
        public Integer read(Tag tag) {
            return ((IntTag)tag).m_7047_();
        }
    };
    public static final IDataSerializer<Long> LONG = new IDataSerializer<Long>(){

        @Override
        public void write(FriendlyByteBuf buf, Long value) {
            buf.writeLong(value.longValue());
        }

        @Override
        public Long read(FriendlyByteBuf buf) {
            return buf.readLong();
        }

        @Override
        public Tag write(Long value) {
            return LongTag.m_128882_((long)value);
        }

        @Override
        public Long read(Tag tag) {
            return ((LongTag)tag).m_7046_();
        }
    };
    public static final IDataSerializer<Float> FLOAT = new IDataSerializer<Float>(){

        @Override
        public void write(FriendlyByteBuf buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float read(FriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public Tag write(Float value) {
            return FloatTag.m_128566_((float)value.floatValue());
        }

        @Override
        public Float read(Tag tag) {
            return Float.valueOf(((FloatTag)tag).m_7057_());
        }
    };
    public static final IDataSerializer<Double> DOUBLE = new IDataSerializer<Double>(){

        @Override
        public void write(FriendlyByteBuf buf, Double value) {
            buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double read(FriendlyByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public Tag write(Double value) {
            return DoubleTag.m_128500_((double)value);
        }

        @Override
        public Double read(Tag tag) {
            return ((DoubleTag)tag).m_7061_();
        }
    };
    public static final IDataSerializer<Character> CHARACTER = new IDataSerializer<Character>(){

        @Override
        public void write(FriendlyByteBuf buf, Character value) {
            buf.writeChar((int)value.charValue());
        }

        @Override
        public Character read(FriendlyByteBuf buf) {
            return Character.valueOf(buf.readChar());
        }

        @Override
        public Tag write(Character value) {
            return IntTag.m_128679_((int)value.charValue());
        }

        @Override
        public Character read(Tag tag) {
            return Character.valueOf((char)((IntTag)tag).m_7047_());
        }
    };
    public static final IDataSerializer<String> STRING = new IDataSerializer<String>(){

        @Override
        public void write(FriendlyByteBuf buf, String value) {
            buf.m_130070_(value);
        }

        @Override
        public String read(FriendlyByteBuf buf) {
            return buf.m_130277_();
        }

        @Override
        public Tag write(String value) {
            return StringTag.m_129297_((String)value);
        }

        @Override
        public String read(Tag tag) {
            return tag.m_7916_();
        }
    };
    public static final IDataSerializer<CompoundTag> TAG_COMPOUND = new IDataSerializer<CompoundTag>(){

        @Override
        public void write(FriendlyByteBuf buf, CompoundTag value) {
            buf.m_130079_(value);
        }

        @Override
        public CompoundTag read(FriendlyByteBuf buf) {
            return buf.m_130260_();
        }

        @Override
        public Tag write(CompoundTag value) {
            return value;
        }

        @Override
        public CompoundTag read(Tag tag) {
            return (CompoundTag)tag;
        }
    };
    public static final IDataSerializer<BlockPos> BLOCK_POS = new IDataSerializer<BlockPos>(){

        @Override
        public void write(FriendlyByteBuf buf, BlockPos value) {
            buf.m_130064_(value);
        }

        @Override
        public BlockPos read(FriendlyByteBuf buf) {
            return buf.m_130135_();
        }

        @Override
        public Tag write(BlockPos value) {
            return LongTag.m_128882_((long)value.m_121878_());
        }

        @Override
        public BlockPos read(Tag tag) {
            return BlockPos.m_122022_((long)((LongTag)tag).m_7046_());
        }
    };
    public static final IDataSerializer<UUID> UUID = new IDataSerializer<UUID>(){

        @Override
        public void write(FriendlyByteBuf buf, UUID value) {
            buf.m_130077_(value);
        }

        @Override
        public UUID read(FriendlyByteBuf buf) {
            return buf.m_130259_();
        }

        @Override
        public Tag write(UUID value) {
            CompoundTag compound = new CompoundTag();
            compound.m_128356_("Most", value.getMostSignificantBits());
            compound.m_128356_("Least", value.getLeastSignificantBits());
            return compound;
        }

        @Override
        public UUID read(Tag tag) {
            CompoundTag compound = (CompoundTag)tag;
            return new UUID(compound.m_128454_("Most"), compound.m_128454_("Least"));
        }
    };
    public static final IDataSerializer<ItemStack> ITEM_STACK = new IDataSerializer<ItemStack>(){

        @Override
        public void write(FriendlyByteBuf buf, ItemStack value) {
            buf.m_130055_(value);
        }

        @Override
        public ItemStack read(FriendlyByteBuf buf) {
            return buf.m_130267_();
        }

        @Override
        public Tag write(ItemStack value) {
            return value.m_41739_(new CompoundTag());
        }

        @Override
        public ItemStack read(Tag tag) {
            return ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
        }
    };
    public static final IDataSerializer<ResourceLocation> RESOURCE_LOCATION = new IDataSerializer<ResourceLocation>(){

        @Override
        public void write(FriendlyByteBuf buf, ResourceLocation value) {
            buf.m_130085_(value);
        }

        @Override
        public ResourceLocation read(FriendlyByteBuf buf) {
            return buf.m_130281_();
        }

        @Override
        public Tag write(ResourceLocation value) {
            return StringTag.m_129297_((String)value.toString());
        }

        @Override
        public ResourceLocation read(Tag tag) {
            return ResourceLocation.m_135820_((String)tag.m_7916_());
        }
    };
}

